/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.internal.core.InputStreamMonitor;
import org.eclipse.debug.internal.core.OutputStreamMonitor;

public class RSEStreamsProxy
implements IStreamsProxy,
IStreamsProxy2 {
    private OSMonitor fOutputMonitor;
    private OSMonitor fErrorMonitor;
    private InputStreamMonitor fInputMonitor;
    private boolean fClosed;

    public RSEStreamsProxy(InputStream sysout, InputStream syserr, OutputStream sysin, String encoding) {
        if (sysout != null) {
            this.fOutputMonitor = new OSMonitor(sysout, encoding);
            this.fOutputMonitor.startMonitoring();
        }
        if (syserr != null) {
            this.fErrorMonitor = new OSMonitor(syserr, encoding);
            this.fErrorMonitor.startMonitoring();
        }
        if (sysin != null) {
            this.fInputMonitor = new InputStreamMonitor(sysin, encoding);
            this.fInputMonitor.startMonitoring();
        }
    }

    public void close() {
        if (!this.isClosed(true)) {
            if (this.fOutputMonitor != null) {
                this.fOutputMonitor.close();
            }
            if (this.fErrorMonitor != null) {
                this.fErrorMonitor.close();
            }
            if (this.fInputMonitor != null) {
                this.fInputMonitor.close();
            }
        }
    }

    private synchronized boolean isClosed(boolean setClosed) {
        boolean closed = this.fClosed;
        if (setClosed) {
            this.fClosed = true;
        }
        return closed;
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.fErrorMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.fOutputMonitor;
    }

    public void write(String input) throws IOException {
        if (this.isClosed(false) || this.fInputMonitor == null) {
            throw new IOException();
        }
        this.fInputMonitor.write(input);
    }

    public void closeInputStream() throws IOException {
        if (this.isClosed(false) || this.fInputMonitor == null) {
            throw new IOException();
        }
        this.fInputMonitor.closeInputStream();
    }

    private static class OSMonitor
    extends OutputStreamMonitor {
        public OSMonitor(InputStream stream, String encoding) {
            super(stream, encoding);
        }

        public void startMonitoring() {
            super.startMonitoring();
        }

        public void close() {
            super.close();
        }
    }
}

