/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.rse.ui.RSEBrowseBehavior;
import org.jboss.ide.eclipse.as.rse.ui.RSEDeploymentPreferenceComposite;
import org.jboss.ide.eclipse.as.rse.ui.RSEUIMessages;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.ui.editor.ServerModeSectionComposite;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;

public class JBoss7RSEDeploymentPrefComposite
extends RSEDeploymentPreferenceComposite {
    private Text rseServerHome;
    private Button rseBrowse;
    private Text rseBaseDirText;
    private Button rseBaseDirBrowse;
    private Text rseConfigFileText;
    private Button rseConfigFileBrowse;
    private ControlDecoration serverHomeDecoration;
    private Label remoteRuntimeRequiredLabel;

    public JBoss7RSEDeploymentPrefComposite(Composite parent, int style, IDeploymentTypeUI.IServerModeUICallback callback) {
        super(parent, style, callback);
        this.validateWidgets(false);
        callback.getServer().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private boolean isRemoteRuntimeRequired() {
        boolean ignoreLaunch;
        String currentProfile = ServerProfileModel.getProfile((IServerAttributes)this.callback.getServer(), (String)"local");
        return !currentProfile.equals("rse.mgmt") || !(ignoreLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)this.callback.getServer()));
    }

    @Override
    protected void propertyChangeBody(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("org.jboss.ide.eclipse.as.core.server.serverMode") || evt.getPropertyName().equals("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS")) {
            this.updateRuntimeLabel();
            this.validateWidgets();
        }
        super.propertyChangeBody(evt);
    }

    private void updateRuntimeLabel() {
        if (this.isRemoteRuntimeRequired()) {
            this.remoteRuntimeRequiredLabel.setText("");
        } else {
            this.remoteRuntimeRequiredLabel.setText("Remote runtime details are optional for your current configuration.");
        }
    }

    @Override
    protected void createRSEWidgets(Composite child2) {
        this.isRemoteRuntimeRequired();
        Group child = new Group(child2, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        child.setLayoutData((Object)data);
        child.setText("Remote Runtime Details");
        child.setLayout((Layout)new FormLayout());
        this.remoteRuntimeRequiredLabel = new Label((Composite)child, 0);
        this.updateRuntimeLabel();
        this.remoteRuntimeRequiredLabel.setLayoutData((Object)FormDataUtility.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)10, (Object)100, (int)-5));
        Label serverHomeLabel = new Label((Composite)child, 0);
        serverHomeLabel.setText(RSEUIMessages.REMOTE_SERVER_HOME_LABEL);
        this.rseBrowse = new Button((Composite)child, 0);
        this.rseBrowse.setText(RSEUIMessages.BROWSE);
        this.rseBrowse.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.remoteRuntimeRequiredLabel, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteHomeBrowseClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteHomeBrowseClicked();
            }
        });
        this.rseServerHome = new Text((Composite)child, 2052);
        serverHomeLabel.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.remoteRuntimeRequiredLabel, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        FormData serverHomeData = FormDataUtility.createFormData2((Object)this.remoteRuntimeRequiredLabel, (int)5, null, (int)0, (Object)serverHomeLabel, (int)10, (Object)this.rseBrowse, (int)-5);
        serverHomeData.width = 150;
        this.rseServerHome.setLayoutData((Object)serverHomeData);
        this.rseServerHome.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", ""));
        this.serverHomeDecoration = new ControlDecoration((Control)this.rseServerHome, 0x1000000);
        this.rseServerHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.serverHomeChanged();
            }
        });
        Label baseDirLabel = new Label((Composite)child, 0);
        baseDirLabel.setText(RSEUIMessages.REMOTE_BASE_DIR_LABEL);
        this.rseBaseDirBrowse = new Button((Composite)child, 0);
        this.rseBaseDirBrowse.setText(RSEUIMessages.BROWSE);
        this.rseBaseDirBrowse.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseBaseDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteBaseDirBrowseClicked();
            }
        });
        this.rseBaseDirText = new Text((Composite)child, 2052);
        baseDirLabel.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.rseServerHome, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        FormData rseBaseDirTextData = FormDataUtility.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, (Object)baseDirLabel, (int)5, (Object)this.rseBaseDirBrowse, (int)-5);
        rseBaseDirTextData.width = 100;
        this.rseBaseDirText.setLayoutData((Object)rseBaseDirTextData);
        this.rseBaseDirText.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", "standalone"));
        this.rseBaseDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.serverBaseDirChanged();
            }
        });
        Label serverConfigLabel = new Label((Composite)child, 0);
        serverConfigLabel.setText(RSEUIMessages.REMOTE_CONFIG_FILE_LABEL);
        this.rseConfigFileBrowse = new Button((Composite)child, 0);
        this.rseConfigFileBrowse.setText(RSEUIMessages.BROWSE);
        this.rseConfigFileBrowse.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.rseBaseDirText, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseConfigFileBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteConfigBrowseClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteConfigBrowseClicked();
            }
        });
        this.rseConfigFileText = new Text((Composite)child, 2052);
        serverConfigLabel.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.rseBaseDirText, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.rseConfigFileText.setLayoutData((Object)FormDataUtility.createFormData2((Object)this.rseBaseDirText, (int)5, null, (int)0, (Object)serverConfigLabel, (int)5, (Object)this.rseConfigFileBrowse, (int)-5));
        this.rseConfigFileText.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", "standalone.xml"));
        this.rseConfigFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.configFileChanged();
            }
        });
        this.validateWidgets();
    }

    protected void serverHomeChanged() {
        if (!this.isUpdatingFromModelChange()) {
            String safeString = this.callback.getRuntime() != null ? (this.callback.getRuntime().getLocation() != null ? this.callback.getRuntime().getLocation().toString() : "") : "";
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", this.rseServerHome.getText(), safeString, RSEUIMessages.CHANGE_REMOTE_SERVER_HOME));
        }
        this.validateWidgets();
    }

    protected String validateWidgets() {
        return this.validateWidgets(true);
    }

    protected String validateWidgets(boolean updateErrorMessage) {
        String errorMsg = null;
        if (this.serverHomeDecoration != null) {
            boolean isEmpty;
            boolean bl = isEmpty = this.rseServerHome == null || this.rseServerHome.getText() == null || this.rseServerHome.getText().trim().isEmpty();
            if (isEmpty && this.isRemoteRuntimeRequired()) {
                this.serverHomeDecoration.setDescriptionText("Remote server home cannot be empty.");
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                this.serverHomeDecoration.setImage(image);
                this.serverHomeDecoration.show();
                errorMsg = this.serverHomeDecoration.getDescriptionText();
            } else {
                this.serverHomeDecoration.hide();
            }
        }
        if (updateErrorMessage) {
            this.callback.setErrorMessage(errorMsg);
        }
        this.callback.setComplete(errorMsg == null);
        return errorMsg;
    }

    protected void serverBaseDirChanged() {
        if (!this.isUpdatingFromModelChange()) {
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", this.rseBaseDirText.getText(), "standalone", RSEUIMessages.CHANGE_REMOTE_BASE_DIR));
        }
    }

    protected void configFileChanged() {
        if (!this.isUpdatingFromModelChange()) {
            IRuntime rt = this.callback.getRuntime();
            LocalJBoss7ServerRuntime jb7srt = rt == null ? null : (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null);
            String safeString = jb7srt == null ? "" : jb7srt.getConfigurationFile();
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", this.rseConfigFileText.getText(), safeString, RSEUIMessages.CHANGE_REMOTE_CONFIG_FILE));
        }
    }

    protected void remoteHomeBrowseClicked() {
        String home = this.rseServerHome.getText() == null ? "" : this.rseServerHome.getText();
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), home);
        if (browseVal != null) {
            this.rseServerHome.setText(browseVal);
            this.serverHomeChanged();
        }
    }

    protected void remoteBaseDirBrowseClicked() {
        String basedir = this.rseBaseDirText.getText() == null ? "" : this.rseBaseDirText.getText();
        String toOpen = null;
        toOpen = new Path(basedir).isAbsolute() ? basedir : new Path(this.rseServerHome.getText()).append(basedir).toString();
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), toOpen);
        if (browseVal != null) {
            if (browseVal.startsWith(this.rseServerHome.getText())) {
                browseVal = new Path(browseVal).makeRelativeTo((IPath)new Path(this.rseServerHome.getText())).toString();
            }
            this.rseBaseDirText.setText(browseVal);
            this.serverBaseDirChanged();
        }
    }

    protected void remoteConfigBrowseClicked() {
        Path home = new Path(this.rseServerHome.getText());
        Path basedir = new Path(this.rseBaseDirText.getText());
        Path basedir2 = basedir.isAbsolute() ? basedir : home.append((IPath)basedir);
        IPath configFolder = basedir2.append("configuration");
        IPath configFile = configFolder.append(this.rseConfigFileText.getText());
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), configFile.toString());
        if (browseVal != null) {
            this.rseConfigFileText.setText(new Path(browseVal).lastSegment());
            this.configFileChanged();
        }
    }
}

