/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.mbeans.project.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.ui.mbeans.Messages;
import org.jboss.ide.eclipse.as.ui.mbeans.SharedImages;
import org.jboss.ide.eclipse.as.ui.mbeans.project.JBossSARFacetProjectCreationDataModelProvider;
import org.jboss.ide.eclipse.as.ui.mbeans.project.SarProjectRuntimeChangedDelegate;
import org.jboss.ide.eclipse.as.ui.mbeans.project.ui.SARProjectFirstPage;
import org.jboss.ide.eclipse.as.wtp.core.vcf.VCFClasspathCommand;

public class SARProjectWizard
extends NewProjectDataModelFacetWizard
implements INewWizard {
    public SARProjectWizard() {
        Set current = this.getFacetedProjectWorkingCopy().getProjectFacets();
        this.getFacetedProjectWorkingCopy().setProjectFacets(current);
        this.setWindowTitle(Messages.NewSarProject_FirstPageTitle);
        this.setDefaultPageImageDescriptor(SharedImages.getImageDescriptor("sar64"));
    }

    public SARProjectWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(Messages.NewSarProject_FirstPageTitle);
        this.setDefaultPageImageDescriptor(SharedImages.getImageDescriptor("sar64"));
    }

    protected IDataModel createDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)new JBossSARFacetProjectCreationDataModelProvider());
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        super.setFacetedProjectWorkingCopy(fpjwc);
    }

    protected IWizardPage createFirstPage() {
        return new SARProjectFirstPage(this.model, "first.page");
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return SharedImages.getImageDescriptor("sar64");
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.jst.jboss.sar");
    }

    protected void postPerformFinish() throws InvocationTargetException {
        super.postPerformFinish();
        String prjName = this.getProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
        IRuntime runtime = null;
        if (project.exists()) {
            try {
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                runtime = fp.getPrimaryRuntime();
            }
            catch (CoreException e) {
                JBossServerCorePlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if (runtime != null) {
            IPath serverContainerPath = SarProjectRuntimeChangedDelegate.getContainerPath(runtime);
            VCFClasspathCommand.addContainerClasspathEntry((IProject)project, (IPath)serverContainerPath);
        }
    }
}

