/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.server.IDeploymentScannerModifier;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;

public class DeploymentScannerSection
extends ServerEditorSection {
    private Button addScannersOnStartup;
    private Button removeScannersOnShutdown;
    private Text intervalText;
    private Text timeoutText;
    private ModifyListener intervalListener;
    private ModifyListener timeoutListener;
    private SelectionListener startupListener;
    private SelectionListener shutdownListener;
    protected ServerAttributeHelper helper;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
        this.setDefaultValues();
        this.addListeners();
    }

    protected void setDefaultValues() {
        int s;
        boolean add = this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true);
        this.addScannersOnStartup.setSelection(new Boolean(add).booleanValue());
        if (this.removeScannersOnShutdown != null) {
            boolean remove = this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true);
            this.removeScannersOnShutdown.setSelection(new Boolean(remove).booleanValue());
        }
        if (this.timeoutText != null) {
            s = this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.deploymentscanner.timeout", -20);
            this.timeoutText.setText(s == -20 ? "(default)" : new Integer(s).toString());
        }
        if (this.intervalText != null) {
            s = this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.deploymentscanner.interval", -20);
            this.intervalText.setText(s == -20 ? "(default)" : new Integer(s).toString());
        }
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 258);
        section.setText("Deployment Scanners");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        this.addScannersOnStartup = toolkit.createButton(composite, "Add missing deployment scanners after server startup.", 32);
        this.addScannersOnStartup.setLayoutData((Object)UIUtil.createFormData2((Object)0, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
        Button top = this.addScannersOnStartup;
        if (this.showIntervalText()) {
            Label intLabel = toolkit.createLabel(composite, "Added Scanner Interval (ms)");
            intLabel.setLayoutData((Object)UIUtil.createFormData2((Object)top, (int)5, null, (int)0, (Object)10, (int)0, null, (int)0));
            this.intervalText = toolkit.createText(composite, "", 32);
            this.intervalText.setLayoutData((Object)UIUtil.createFormData2((Object)top, (int)5, null, (int)0, (Object)50, (int)5, (Object)80, (int)0));
            top = this.intervalText;
        }
        if (this.showTimeoutText()) {
            Label timeLabel = toolkit.createLabel(composite, "Added Scanner Timeout (sec)");
            timeLabel.setLayoutData((Object)UIUtil.createFormData2((Object)top, (int)5, null, (int)0, (Object)10, (int)0, null, (int)0));
            this.timeoutText = toolkit.createText(composite, "", 32);
            this.timeoutText.setLayoutData((Object)UIUtil.createFormData2((Object)top, (int)5, null, (int)0, (Object)50, (int)5, (Object)80, (int)0));
            top = this.timeoutText;
        }
        if (this.showRemoveScannerButton()) {
            this.removeScannersOnShutdown = toolkit.createButton(composite, "Remove added deployment scanners before shutdown.", 32);
            this.removeScannersOnShutdown.setLayoutData((Object)UIUtil.createFormData2((Object)top, (int)5, null, (int)0, (Object)0, (int)5, null, (int)0));
            top = this.removeScannersOnShutdown;
        }
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private boolean showRemoveScannerButton() {
        IDeploymentScannerModifier scanner;
        JBossExtendedProperties props = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, null);
        return props != null && (scanner = props.getDeploymentScannerModifier()) instanceof AbstractDeploymentScannerAdditions && ((AbstractDeploymentScannerAdditions)scanner).persistsScannerChanges();
    }

    private boolean showTimeoutText() {
        IDeploymentScannerModifier scanner;
        JBossExtendedProperties props = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, null);
        return props != null && (scanner = props.getDeploymentScannerModifier()) instanceof AbstractDeploymentScannerAdditions && ((AbstractDeploymentScannerAdditions)scanner).canCustomizeTimeout();
    }

    private boolean showIntervalText() {
        IDeploymentScannerModifier scanner;
        JBossExtendedProperties props = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, null);
        return props != null && (scanner = props.getDeploymentScannerModifier()) instanceof AbstractDeploymentScannerAdditions && ((AbstractDeploymentScannerAdditions)scanner).canCustomizeInterval();
    }

    protected void addListeners() {
        this.startupListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentScannerSection.this.execute((IUndoableOperation)new SetStartupPropertyCommand(DeploymentScannerSection.this.server));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.shutdownListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentScannerSection.this.execute((IUndoableOperation)new SetShutdownPropertyCommand(DeploymentScannerSection.this.server));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.intervalListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentScannerSection.this.execute((IUndoableOperation)new SetIntervalPropertyCommand(DeploymentScannerSection.this.server));
            }
        };
        this.timeoutListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentScannerSection.this.execute((IUndoableOperation)new SetTimeoutPropertyCommand(DeploymentScannerSection.this.server));
            }
        };
        this.addScannersOnStartup.addSelectionListener(this.startupListener);
        if (this.showRemoveScannerButton()) {
            this.removeScannersOnShutdown.addSelectionListener(this.shutdownListener);
        }
        if (this.showIntervalText()) {
            this.intervalText.addModifyListener(this.intervalListener);
        }
        if (this.showTimeoutText()) {
            this.timeoutText.addModifyListener(this.timeoutListener);
        }
    }

    private class SetIntervalPropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetIntervalPropertyCommand(IServerWorkingCopy server) {
            super(server, "Modify deployment scanner interval preference", DeploymentScannerSection.this.intervalText, DeploymentScannerSection.this.intervalText.getText(), "org.jboss.ide.eclipse.as.core.server.deploymentscanner.interval", "(default)", DeploymentScannerSection.this.intervalListener);
        }
    }

    public class SetShutdownPropertyCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetShutdownPropertyCommand(IServerWorkingCopy server) {
            super(server, "Modify deployment scanner shutdown preference", DeploymentScannerSection.this.removeScannersOnShutdown, DeploymentScannerSection.this.removeScannersOnShutdown.getSelection(), "org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", DeploymentScannerSection.this.shutdownListener, true);
        }
    }

    public class SetStartupPropertyCommand
    extends ServerWorkingCopyPropertyButtonCommand {
        public SetStartupPropertyCommand(IServerWorkingCopy server) {
            super(server, "Modify deployment scanner startup preference", DeploymentScannerSection.this.addScannersOnStartup, DeploymentScannerSection.this.addScannersOnStartup.getSelection(), "org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", DeploymentScannerSection.this.startupListener, true);
        }
    }

    private class SetTimeoutPropertyCommand
    extends ServerWorkingCopyPropertyTextCommand {
        public SetTimeoutPropertyCommand(IServerWorkingCopy server) {
            super(server, "Modify deployment scanner timeout preference", DeploymentScannerSection.this.timeoutText, DeploymentScannerSection.this.timeoutText.getText(), "org.jboss.ide.eclipse.as.core.server.deploymentscanner.timeout", "(default)", DeploymentScannerSection.this.timeoutListener);
        }
    }
}

