/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Trace;

public class DelayedServerWorkingCopy
implements IServerWorkingCopy {
    private IServerWorkingCopy original;
    private Object rt;
    private Object configFolder;
    private Map<String, Object> map = new HashMap<String, Object>();
    private Object myNull = new Object();
    private transient List<PropertyChangeListener> propertyListeners;
    private boolean dirty;

    public DelayedServerWorkingCopy(IServerWorkingCopy original) {
        this.original = original;
        this.rt = null;
        this.configFolder = null;
        this.propertyListeners = new ArrayList<PropertyChangeListener>();
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getName() {
        return this.getAttribute("name", "");
    }

    public String getId() {
        return this.getAttribute("id", "");
    }

    public void delete() throws CoreException {
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        return null;
    }

    public void setHost(String host) {
        this.setAttribute("hostname", host);
    }

    public String getHost() {
        return this.getAttribute("hostname", "localhost");
    }

    public IServerType getServerType() {
        return this.original.getServerType();
    }

    public IServerWorkingCopy createWorkingCopy() {
        return null;
    }

    public IModule[] getModules() {
        return this.original.getModules();
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IModule[] getChildModules(IModule[] module, IProgressMonitor monitor) {
        return this.original.getChildModules(module, monitor);
    }

    public IModule[] getRootModules(IModule module, IProgressMonitor monitor) throws CoreException {
        return this.original.getRootModules(module, monitor);
    }

    public ServerPort[] getServerPorts(IProgressMonitor monitor) {
        return this.original.getServerPorts(monitor);
    }

    public void setReadOnly(boolean readOnly) {
    }

    public IFolder getServerConfiguration() {
        if (this.configFolder == null) {
            return this.original.getServerConfiguration();
        }
        if (this.configFolder == this.myNull) {
            return null;
        }
        return (IFolder)this.configFolder;
    }

    public void setServerConfiguration(IFolder configuration) {
        this.configFolder = configuration == null ? this.myNull : configuration;
        this.setAttribute("configuration-id", configuration == null ? null : configuration.getFullPath().toString());
    }

    public IServer getOriginal() {
        return this.original.getOriginal();
    }

    public IServer save(boolean force, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public IServer saveAll(boolean force, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public IRuntime getRuntime() {
        if (this.rt == null) {
            return this.original.getRuntime();
        }
        if (this.rt == this.myNull) {
            return null;
        }
        return (IRuntime)this.rt;
    }

    public void setRuntime(IRuntime runtime) {
        this.rt = runtime;
        this.setAttribute("runtime-id", runtime == null ? runtime.getId() : null);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Object obj = this.map.get(attributeName);
        if (obj == null) {
            return this.original.getAttribute(attributeName, defaultValue);
        }
        if (obj == this.myNull) {
            return defaultValue;
        }
        return Integer.parseInt((String)obj);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Object obj = this.map.get(attributeName);
        if (obj == null) {
            return this.original.getAttribute(attributeName, defaultValue);
        }
        if (obj == this.myNull) {
            return defaultValue;
        }
        return Boolean.valueOf((String)obj);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Object obj = this.map.get(attributeName);
        if (obj == null) {
            return this.original.getAttribute(attributeName, defaultValue);
        }
        if (obj == this.myNull) {
            return defaultValue;
        }
        return (String)obj;
    }

    public List<String> getAttribute(String attributeName, List<String> defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return this.original.getAttribute(attributeName, defaultValue);
            }
            if (obj == this.myNull) {
                return defaultValue;
            }
            return (List)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Map getAttribute(String attributeName, Map defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return this.original.getAttribute(attributeName, defaultValue);
            }
            if (obj == this.myNull) {
                return defaultValue;
            }
            return (Map)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void setAttribute(String attributeName, int value) {
        int current = this.getAttribute(attributeName, 0);
        this.map.put(attributeName, Integer.toString(value));
        this.firePropertyChangeEvent(attributeName, new Integer(current), new Integer(value));
        this.dirty = true;
    }

    public void setAttribute(String attributeName, boolean value) {
        boolean current = this.getAttribute(attributeName, value);
        this.map.put(attributeName, Boolean.toString(value));
        this.firePropertyChangeEvent(attributeName, new Boolean(current), new Boolean(value));
        this.dirty = true;
    }

    public void setAttribute(String attributeName, String value) {
        String current = this.getAttribute(attributeName, value);
        this.map.put(attributeName, value);
        this.firePropertyChangeEvent(attributeName, current, value);
        this.dirty = true;
    }

    public void setAttribute(String attributeName, List<String> value) {
        List<String> current = this.getAttribute(attributeName, value);
        this.map.put(attributeName, value);
        this.firePropertyChangeEvent(attributeName, current, value);
        this.dirty = true;
    }

    public void setAttribute(String attributeName, Map value) {
        Map current = this.getAttribute(attributeName, value);
        this.map.put(attributeName, value);
        this.firePropertyChangeEvent(attributeName, current, value);
        this.dirty = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        block6: {
            if (this.propertyListeners == null) {
                return;
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            try {
                Iterator<PropertyChangeListener> iterator = this.propertyListeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        PropertyChangeListener listener = iterator.next();
                        listener.propertyChange(event);
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) continue;
                        Trace.trace((String)"/severe", (String)"Error firing property change event", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block6;
                Trace.trace((String)"/severe", (String)"Error in property event", (Throwable)e);
            }
        }
    }

    public void saveToOriginalWorkingCopy() {
        for (String k : this.map.keySet()) {
            Object v = this.map.get(k);
            if (v == this.myNull) {
                this.original.setAttribute(k, (String)v);
            }
            if (v instanceof String) {
                this.original.setAttribute(k, (String)v);
            }
            if (v instanceof List) {
                this.original.setAttribute(k, (List)v);
            }
            if (!(v instanceof Map)) continue;
            this.original.setAttribute(k, (Map)v);
        }
        if (this.rt != null) {
            this.original.setRuntime(this.rt == this.myNull ? null : (IRuntime)this.rt);
        }
        if (this.configFolder != null) {
            this.original.setServerConfiguration(this.configFolder == this.myNull ? null : (IFolder)this.configFolder);
        }
    }
}

