/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.ports;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.editor.ports.IPortEditorExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortSection;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyButtonCommand;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyTextCommand;

public class DebugPortSection
implements IPortEditorExtension {
    private ServerAttributeHelper helper;
    private PortSection section;

    @Override
    public void setServerAttributeHelper(ServerAttributeHelper helper) {
        this.helper = helper;
    }

    @Override
    public void setSection(PortSection section) {
        this.section = section;
    }

    @Override
    public void createControl(Composite parent) {
        String profile = ServerProfileModel.getProfile((IServerAttributes)this.helper.getOriginal());
        final Button check = new Button(parent, 32);
        check.setText("Attach remote debugger");
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        check.setLayoutData((Object)gd);
        Label l2 = new Label(parent, 0);
        l2.setText("Debug Port");
        final Text portText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).minSize(80, 10).grab(true, false).applyTo((Control)portText);
        portText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text == null || e.text.equals("")) {
                    return;
                }
                try {
                    Integer i = Integer.parseInt(e.text);
                    if (i == 0) {
                        e.doit = false;
                    }
                }
                catch (NumberFormatException nfe) {
                    e.doit = false;
                }
            }
        });
        Boolean b = this.helper.getWorkingCopy().getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", true);
        check.setSelection(b.booleanValue());
        check.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServerWorkingCopyPropertyButtonCommand command = new ServerWorkingCopyPropertyButtonCommand(DebugPortSection.this.helper.getWorkingCopy(), "Enable debugging", check, check.getSelection(), "org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", (SelectionListener)this);
                DebugPortSection.this.section.execute((IUndoableOperation)command);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String dbugPort = this.helper.getWorkingCopy().getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.DEBUG_PORT", new Integer(8787).toString());
        portText.setText(dbugPort);
        portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerWorkingCopyPropertyTextCommand command = new ServerWorkingCopyPropertyTextCommand(DebugPortSection.this.helper.getWorkingCopy(), "Change Debug Port", portText, portText.getText(), "org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.DEBUG_PORT", new Integer(8787).toString(), (ModifyListener)this);
                DebugPortSection.this.section.execute((IUndoableOperation)command);
            }
        });
        boolean initialEnablement = this.getEnablement();
        check.setEnabled(initialEnablement);
        portText.setEnabled(initialEnablement);
        this.helper.getWorkingCopy().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS")) {
                    boolean initialEnablement = DebugPortSection.this.getEnablement();
                    check.setEnabled(initialEnablement);
                    portText.setEnabled(initialEnablement);
                }
            }
        });
    }

    protected boolean getEnablement() {
        boolean deployOnly = this.helper.getWorkingCopy().getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer");
        boolean profileRSE = ServerProfileModel.getProfile((IServerAttributes)this.helper.getWorkingCopy()).contains("rse");
        boolean externallyManaged = LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)this.helper.getWorkingCopy());
        if (deployOnly || profileRSE) {
            return true;
        }
        return externallyManaged;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void refresh() {
    }
}

