/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ResourceNode;
import org.jboss.tools.as.wst.server.ui.xpl.ServerToolTip;

public class ServerContentTreeContentProvider
implements ITreeContentProvider {
    static final Object PENDING = new Object();
    private ConcurrentMap<IContainerNode<?>, Object> pendingUpdates = new ConcurrentHashMap();
    private transient TreeViewer viewer;
    private Job loadElementJob = new Job(Messages.ServerContent_Job_Title){

        public boolean shouldRun() {
            return ServerContentTreeContentProvider.this.pendingUpdates.size() > 0;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ServerContent_Job_Title, -1);
            try {
                final ArrayList<IContainerNode> updatedNodes = new ArrayList<IContainerNode>(ServerContentTreeContentProvider.this.pendingUpdates.size());
                for (IContainerNode node : ServerContentTreeContentProvider.this.pendingUpdates.keySet()) {
                    try {
                        node.load();
                        updatedNodes.add(node);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!monitor.isCanceled()) continue;
                    ServerContentTreeContentProvider.this.pendingUpdates.keySet().removeAll(updatedNodes);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                final TreeViewer viewer = ServerContentTreeContentProvider.this.viewer;
                if (viewer == null) {
                    ServerContentTreeContentProvider.this.pendingUpdates.keySet().clear();
                } else {
                    viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (viewer.getTree().isDisposed()) {
                                return;
                            }
                            for (IContainerNode node : updatedNodes) {
                                ServerContentTreeContentProvider.this.pendingUpdates.remove(node);
                                viewer.refresh((Object)node);
                            }
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    };
    private ServerToolTip tooltip = null;

    public void dispose() {
        this.viewer = null;
        this.loadElementJob.cancel();
        this.pendingUpdates.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        } else {
            viewer = null;
        }
        if (this.tooltip != null) {
            this.tooltip.deactivate();
        }
        this.tooltip = new ServerToolTip(((TreeViewer)viewer).getTree()){

            @Override
            protected boolean isMyType(Object selected) {
                return selected instanceof ResourceNode;
            }

            @Override
            protected void fillStyledText(Composite parent, StyledText sText, Object o) {
                sText.setText("View JBoss-7 management details.");
            }
        };
        this.tooltip.setShift(new Point(15, 8));
        this.tooltip.setPopupDelay(500);
        this.tooltip.setHideOnMouseDown(true);
        this.tooltip.activate();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            return new Object[]{new ResourceNode((IServer)parentElement, "root")};
        }
        if (parentElement instanceof IContainerNode) {
            IContainerNode container = (IContainerNode)parentElement;
            if (this.pendingUpdates.containsKey(container)) {
                return new Object[]{PENDING};
            }
            List<IContentNode<?>> children = container.getChildren();
            if (children == null) {
                this.pendingUpdates.putIfAbsent(container, PENDING);
                this.loadElementJob.schedule();
                return new Object[]{PENDING};
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IContentNode) {
            Object parent = ((IContentNode)element).getContainer();
            if (parent == null) {
                parent = ((IContentNode)element).getServer();
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return true;
        }
        return element instanceof IContainerNode;
    }
}

