/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.bean;

import java.io.File;
import java.util.regex.Pattern;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanTypeEAP;

public class ServerBeanTypeSOAP
extends JBossServerType {
    private static final String TWIDDLE_JAR_NAME = "twiddle.jar";
    private static final String SOAP_JBPM_JPDL_PATH = "jbpm-jpdl";

    public ServerBeanTypeSOAP() {
        super("SOA-P", "SOA Platform", ServerBeanTypeSOAP.asPath("jboss-as", "bin", TWIDDLE_JAR_NAME), new String[]{"4.3", "5.0", "5.1"}, new SOAPServerTypeCondition());
    }

    @Override
    public String getRootToAdapterRelativePath(String version) {
        return "jboss-as";
    }

    public static class SOAPServerTypeCondition
    extends ServerBeanTypeEAP.EAPServerTypeCondition {
        @Override
        public boolean isServerRoot(File location) {
            File jbpmFolder = new File(location, ServerBeanTypeSOAP.SOAP_JBPM_JPDL_PATH);
            return super.isServerRoot(location) && jbpmFolder.exists() && jbpmFolder.isDirectory();
        }

        @Override
        public String getFullVersion(File location, File systemFile) {
            String fullVersion = super.getFullVersion(location, systemFile);
            if (fullVersion != null && fullVersion.length() >= 5) {
                String check = fullVersion.substring(0, 5);
                Pattern pattern = Pattern.compile("5\\.1\\.[1-9]");
                Pattern pattern531 = Pattern.compile("5\\.2\\.[0-9]");
                if (pattern.matcher(check).matches() || pattern531.matcher(check).matches()) {
                    String runJar = "jboss-as" + File.separatorChar + "bin" + File.separatorChar + "run.jar";
                    fullVersion = super.getFullVersion(location, new File(location, runJar));
                }
            }
            return fullVersion;
        }
    }
}

