/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.Messages;

public class ArgsUtil {
    public static final Integer NO_VALUE = new Integer(-1);
    public static final String EQ = "=";
    public static final String SPACE = " ";
    public static final String VMO = "-D";
    public static final String EMPTY = "";
    public static final String QUOTE = "\"";

    public static String[] parse(String s) {
        if (s == null) {
            return new String[0];
        }
        s = s.trim();
        try {
            ArrayList<String> l = new ArrayList<String>();
            int length = s.length();
            int current = 0;
            boolean inQuotes = false;
            boolean done = false;
            String tmp = EMPTY;
            StringBuffer buf = new StringBuffer();
            if (s.length() == 0) {
                done = true;
            }
            while (!done) {
                switch (s.charAt(current)) {
                    case '\"': {
                        inQuotes = !inQuotes;
                        buf.append(s.charAt(current));
                        break;
                    }
                    case '\n': 
                    case ' ': {
                        if (!inQuotes) {
                            tmp = buf.toString();
                            if (!tmp.trim().equals(EMPTY)) {
                                l.add(tmp);
                            }
                            buf = new StringBuffer();
                            break;
                        }
                        buf.append(' ');
                        break;
                    }
                    default: {
                        buf.append(s.charAt(current));
                    }
                }
                if (++current != length) continue;
                done = true;
            }
            l.add(buf.toString());
            Object[] lArr = l.toArray();
            String[] retVal = new String[lArr.length];
            int i = 0;
            while (i < lArr.length) {
                retVal[i] = (String)lArr[i];
                ++i;
            }
            return retVal;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.ServerArgsParseError, (Object)s), (Throwable)e);
            ASWTPToolsPlugin.log((IStatus)status);
            return new String[0];
        }
    }

    public static Map<String, Object> getSystemProperties(String argString) {
        String[] args = ArgsUtil.parse(argString);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(VMO)) {
                int eq = args[i].indexOf(EQ);
                if (eq != -1) {
                    map.put(args[i].substring(2, eq), args[i].substring(eq + 1));
                } else {
                    map.put(args[i], NO_VALUE);
                }
            }
            ++i;
        }
        return map;
    }

    public static String getValue(String allArgs, String shortOpt, String longOpt) {
        return ArgsUtil.getValue(ArgsUtil.parse(allArgs), shortOpt, longOpt);
    }

    public static String getValue(String[] args, String shortOpt, String longOpt) {
        String[] stringArray;
        String[] stringArray2;
        if (shortOpt == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = shortOpt;
        }
        String[] shortOpt2 = stringArray2;
        if (longOpt == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = longOpt;
        }
        String[] longOpt2 = stringArray;
        return ArgsUtil.getValue(args, shortOpt2, longOpt2);
    }

    public static String getValue(String allArgs, String[] shortOpt, String[] longOpt) {
        return ArgsUtil.getValue(ArgsUtil.parse(allArgs), shortOpt, longOpt);
    }

    public static String getValue(String[] args, String[] shortOpt, String[] longOpt) {
        int i = 0;
        while (i < args.length) {
            if (shortOpt != null && ArgsUtil.matchesShortArg(args[i], shortOpt) && i + 1 < args.length) {
                return args[i + 1];
            }
            if (longOpt != null && ArgsUtil.matchesLongArg(args[i], longOpt)) {
                return args[i].substring(args[i].indexOf(EQ) + 1);
            }
            ++i;
        }
        return null;
    }

    public static boolean matchesShortArg(String needle, String[] haystack) {
        if (haystack == null) {
            return false;
        }
        return Arrays.asList(haystack).contains(needle);
    }

    public static boolean matchesLongArg(String needle, String[] haystack) {
        if (haystack == null) {
            return false;
        }
        int i = 0;
        while (i < haystack.length) {
            if (needle.startsWith(String.valueOf(haystack[i]) + EQ) || needle.startsWith(QUOTE + haystack[i] + EQ)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String setArg(String allArgs, String shortOpt, String longOpt, String value) {
        if (!(value == null || !value.contains(SPACE) || value.startsWith(QUOTE) && value.endsWith(QUOTE))) {
            value = QUOTE + value + QUOTE;
        }
        return ArgsUtil.setArg(allArgs, shortOpt, longOpt, value, false);
    }

    public static String setArg(String allArgs, String shortOpt, String longOpt, String value, boolean addQuotes) {
        String[] stringArray;
        String[] stringArray2;
        if (shortOpt == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = shortOpt;
        }
        String[] shortOpt2 = stringArray2;
        if (longOpt == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = longOpt;
        }
        String[] longOpt2 = stringArray;
        return ArgsUtil.setArg(allArgs, shortOpt2, longOpt2, value, addQuotes);
    }

    public static String setArg(String allArgs, String[] shortOpt, String[] longOpt, String value, boolean addQuotes) {
        String originalValue;
        String rawValue = originalValue = value;
        if (value != null && addQuotes) {
            value = QUOTE + value + QUOTE;
        } else {
            rawValue = ArgsUtil.getRawValue(value);
        }
        boolean found = false;
        String[] args = ArgsUtil.parse(allArgs);
        String retVal = EMPTY;
        int i = 0;
        while (i < args.length) {
            if (ArgsUtil.matchesShortArg(args[i], shortOpt)) {
                if (value != null) {
                    args[i + 1] = value;
                    retVal = String.valueOf(retVal) + args[i] + SPACE + args[++i] + SPACE;
                }
                found = true;
            } else if (ArgsUtil.matchesLongArg(args[i], longOpt)) {
                if (value != null) {
                    String newVal = null;
                    newVal = args[i].startsWith(QUOTE) ? QUOTE + longOpt[0] + EQ + rawValue + QUOTE : String.valueOf(longOpt[0]) + EQ + value;
                    args[i] = newVal;
                    retVal = String.valueOf(retVal) + args[i] + SPACE;
                }
                found = true;
            } else {
                retVal = String.valueOf(retVal) + args[i] + SPACE;
            }
            ++i;
        }
        if (!found) {
            retVal = longOpt != null && longOpt.length > 0 ? String.valueOf(retVal) + longOpt[0] + EQ + value : String.valueOf(retVal) + shortOpt[0] + SPACE + value;
        }
        return retVal;
    }

    private static String getRawValue(String original) {
        if (original != null && original.startsWith(QUOTE) && original.endsWith(QUOTE)) {
            original = original.substring(1);
            original = original.substring(0, original.length() - 1);
        }
        return original;
    }

    public static String setFlag(String original, String flagName) {
        if (original.startsWith(String.valueOf(flagName) + SPACE) || original.contains(SPACE + flagName + SPACE) || original.endsWith(flagName)) {
            return original;
        }
        return String.valueOf(original.trim()) + SPACE + flagName;
    }

    public static String clearFlag(String original, String flagName) {
        if (original.trim().startsWith(String.valueOf(flagName) + SPACE)) {
            return original.trim().substring(flagName.length()).trim();
        }
        if (original.contains(SPACE + flagName + SPACE)) {
            return original.replace(SPACE + flagName + SPACE, SPACE).trim();
        }
        if (original.trim().endsWith(SPACE + flagName)) {
            return original.trim().substring(0, original.trim().length() - flagName.length()).trim();
        }
        if (original.trim().equals(flagName)) {
            return EMPTY;
        }
        return original.trim();
    }
}

