/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IDeployableServerBehaviour;
import org.jboss.ide.eclipse.as.core.server.IPublishCopyCallbackHandler;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.core.util.PublishCopyUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.StreamUtils;

@Deprecated
public class LocalCopyCallback
implements IPublishCopyCallbackHandler {
    private static final File tempDir = ServerPlugin.getInstance().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = "tmp";
    private boolean shouldRestartModule = false;
    private IServer server;
    private IPath deployRootFolder;
    private IPath tmpDeployRootFolder;

    @Deprecated
    public LocalCopyCallback(IServer server, IPath deployFolder, IPath temporaryFolder) {
        this.server = server;
        this.deployRootFolder = deployFolder;
        this.tmpDeployRootFolder = temporaryFolder;
    }

    @Override
    public boolean shouldRestartModule() {
        return this.shouldRestartModule;
    }

    @Override
    public IStatus[] copyFile(IModuleFile mf, IPath relativePath, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Copying " + relativePath.toString(), 100);
        File file = ModuleResourceUtil.getFile(mf);
        IDeployableServerBehaviour beh = ServerConverter.getDeployableServerBehavior(this.server);
        this.shouldRestartModule |= beh != null && beh.changedFileRequiresModuleRestart(mf);
        if (file != null) {
            if (!file.exists()) {
                return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorReading, (Object)file.getAbsolutePath()), null)};
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorReading, (Object)file.getAbsolutePath()), (Throwable)e)};
            }
            IStatus ret = this.copyFile(in, this.deployRootFolder.append(relativePath), file.lastModified(), mf);
            monitor.worked(100);
            monitor.done();
            if (ret != null && !ret.isOK()) {
                return new IStatus[]{ret};
            }
        }
        return new IStatus[0];
    }

    private IStatus copyFile(InputStream in, String to) {
        try {
            FileUtil.writeTo(in, to);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            return status;
        }
        finally {
            StreamUtils.safeClose(in);
        }
    }

    private IStatus copyFile(InputStream in, IPath to, long ts, IModuleFile mf) throws CoreException {
        File tempFile = null;
        try {
            try {
                File file = to.toFile();
                tempFile = this.writeToTempFile(in, to);
                this.moveTempFile(tempFile, file);
                if (ts != -1L && ts != 0L) {
                    file.setLastModified(ts);
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                Status status = new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorCopyingFile, (Object)path.toOSString(), (Object)e.getLocalizedMessage()), null);
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return status;
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private File writeToTempFile(InputStream in, IPath filePath) throws IOException {
        File tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + filePath.getFileExtension(), this.getTempFolder());
        FileUtil.writeTo(in, tempFile);
        return tempFile;
    }

    private void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !this.safeDelete(file, 2)) {
            try {
                FileInputStream in = new FileInputStream(tempFile);
                IStatus status = this.copyFile(in, file.getPath());
                this.throwOnErrorStatus(file, status);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                tempFile.delete();
            }
        }
        if (!this.safeRename(tempFile, file, 10)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 1644298249, NLS.bind((String)org.jboss.ide.eclipse.as.wtp.core.Messages.PublishRenameFailure, (Object)tempFile.toString(), (Object)file.getAbsolutePath()), null));
        }
    }

    private void throwOnErrorStatus(File file, IStatus status) throws CoreException {
        if (!status.isOK()) {
            String msg = NLS.bind((String)Messages.errorDeleting, (Object)file.toString());
            Throwable t = status.getException() == null ? new Exception(msg) : status.getException();
            MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.core", 1644298251, msg, t);
            status2.add(status);
            throw new CoreException((IStatus)status2);
        }
    }

    private boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    protected File getTempFolder() {
        if (this.tmpDeployRootFolder == null && this.server == null) {
            return tempDir;
        }
        File f = null;
        if (this.tmpDeployRootFolder != null) {
            f = this.tmpDeployRootFolder.toFile();
        } else {
            IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.server);
            if (ds == null) {
                return tempDir;
            }
            String path = ds.getTempDeployFolder();
            f = new File(path);
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    @Override
    public IStatus[] deleteResource(IPath resource, IProgressMonitor monitor) {
        resource = this.deployRootFolder.append(resource);
        File file = resource.toFile();
        IStatus[] results = new IStatus[]{};
        if (file.isDirectory()) {
            results = this.deleteDirectory(resource.toFile(), monitor);
        } else if (!file.delete()) {
            String msg = NLS.bind((String)Messages.errorDeleting, (Object)resource.toFile().getAbsolutePath());
            Status s = new Status(4, "org.eclipse.wst.server.core", 1644298251, msg, (Throwable)new Exception(msg));
            results = new IStatus[]{s};
        }
        return results;
    }

    private IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 1644298251, NLS.bind((String)Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null)};
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        try {
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            boolean deleteCurrent = true;
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    if (!current.delete()) {
                        String msg = NLS.bind((String)Messages.errorDeleting, (Object)files[i].getAbsolutePath());
                        status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 1644298251, msg, (Throwable)new Exception(msg)));
                        deleteCurrent = false;
                    }
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    IStatus[] stat = this.deleteDirectory(current, ProgressMonitorUtil.getSubMon(monitor, 10));
                    if (stat != null && stat.length > 0) {
                        deleteCurrent = false;
                        PublishCopyUtil.addArrayToList(status, stat);
                    }
                }
                ++i;
            }
            if (deleteCurrent && !dir.delete()) {
                String msg = NLS.bind((String)Messages.errorDeleting, (Object)dir.getAbsolutePath());
                status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 1644298251, msg, (Throwable)new Exception(msg)));
            }
            monitor.done();
        }
        catch (Exception e) {
            status.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 1644298251, e.getLocalizedMessage(), null));
        }
        return status.toArray(new IStatus[status.size()]);
    }

    private boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (!f.exists()) {
                return true;
            }
            f.delete();
            if (!f.exists()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public IStatus[] makeDirectoryIfRequired(IPath relativeDir, IProgressMonitor monitor) {
        this.deployRootFolder.append(relativeDir).toFile().mkdirs();
        return new IStatus[]{Status.OK_STATUS};
    }

    @Override
    public IStatus[] touchResource(IPath path, IProgressMonitor monitor) {
        File tmp = this.deployRootFolder.append(path).toFile();
        if (!tmp.exists()) {
            tmp = this.deployRootFolder.toFile();
        }
        tmp.setLastModified(new Date().getTime());
        return null;
    }

    @Override
    public boolean isFile(IPath path, IProgressMonitor monitor) throws CoreException {
        File tmp = this.deployRootFolder.append(path).toFile();
        return tmp.exists() && tmp.isFile();
    }
}

