/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class ServerCreationUtils {
    public static IServer createDeployOnlyServer(String deployLocation, String tempDeployLocation, String rtName, String serverName) throws CoreException {
        return ServerCreationUtils.createDeployOnlyServerWorkingCopy(deployLocation, tempDeployLocation, rtName, serverName).save(true, null);
    }

    public static IServerWorkingCopy createDeployOnlyServerWorkingCopy(String deployLocation, String tempDeployLocation, String rtName, String serverName) throws CoreException {
        IRuntimeType rt = ServerCore.findRuntimeType((String)"org.jboss.ide.eclipse.as.runtime.stripped");
        IRuntimeWorkingCopy wc = rt.createRuntime(rtName, null);
        IRuntime runtime = wc.save(true, null);
        IServerType st = ServerCore.findServerType((String)"org.jboss.ide.eclipse.as.systemCopyServer");
        ServerWorkingCopy swc = (ServerWorkingCopy)st.createServer(serverName, null, null);
        swc.setServerConfiguration(null);
        swc.setName(serverName);
        swc.setRuntime(runtime);
        swc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", deployLocation);
        swc.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", tempDeployLocation);
        return swc;
    }

    public static IServer createServer2(IRuntime currentRuntime, String serverTypeId) throws CoreException {
        return ServerCreationUtils.createServer2(currentRuntime, serverTypeId, serverTypeId);
    }

    public static IServer createServer2(IRuntime currentRuntime, String serverTypeId, String serverName) throws CoreException {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        return ServerCreationUtils.createServer2(currentRuntime, serverType, serverName);
    }

    public static IServer createServer2(IRuntime currentRuntime, String serverTypeId, String serverName, String mode) throws CoreException {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        return ServerCreationUtils.createServer2(currentRuntime, serverType, serverName, mode);
    }

    public static IServer createServer2(IRuntime currentRuntime, IServerType serverType, String serverName) throws CoreException {
        return ServerCreationUtils.createServer2(currentRuntime, serverType, serverName, "local");
    }

    public static IServerWorkingCopy createServerWorkingCopy(IRuntime currentRuntime, IServerType serverType, String serverName, String mode) throws CoreException {
        IServerWorkingCopy serverWC = serverType.createServer(null, null, (IProgressMonitor)new NullProgressMonitor());
        serverWC.setRuntime(currentRuntime);
        serverWC.setName(serverName);
        serverWC.setServerConfiguration(null);
        ServerProfileModel.setProfile(serverWC, mode);
        return serverWC;
    }

    public static IServer createServer2(IRuntime currentRuntime, IServerType serverType, String serverName, String mode) throws CoreException {
        return ServerCreationUtils.createServerWorkingCopy(currentRuntime, serverType, serverName, mode).save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IRuntime createRuntime(String runtimeId, String homeDir, String config, IExecutionEnvironment environment) throws CoreException {
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes(null, null, (String)runtimeId);
        IRuntimeType runtimeType = runtimeTypes[0];
        IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
        runtimeWC.setName(runtimeId);
        runtimeWC.setLocation((IPath)new Path(homeDir));
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("PROPERTY_EXEC_ENVIRONMENT", environment.getId());
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", config);
        IRuntime savedRuntime = runtimeWC.save(true, (IProgressMonitor)new NullProgressMonitor());
        return savedRuntime;
    }
}

