/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.publish;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class BinaryModulePublishRunner {
    private IModule[] module;
    private IPath archiveDestination;
    private IPath archiveDestinationWithName;
    private IFilesystemController fc;
    private IModuleResource[] all;
    private IModuleResourceDelta[] delta;

    public BinaryModulePublishRunner(IModule[] module, IPath archiveDestination, IPath archiveDestinationWithName, IFilesystemController fc, IModuleResource[] all, IModuleResourceDelta[] delta) {
        this.module = module;
        this.archiveDestination = archiveDestination;
        this.archiveDestinationWithName = archiveDestinationWithName;
        this.fc = fc;
        this.all = all;
        this.delta = delta;
    }

    public MultiStatus removeBinaryModule(IProgressMonitor monitor) throws CoreException {
        boolean nestedSingle = this.isNestedSingleResourceBinaryModule();
        if (nestedSingle) {
            return this.removeDeletedBinaryModule(monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        MultiStatus ms = this.removeDeletedBinaryModule((IProgressMonitor)progress.split(1));
        this.removeMembers(this.all, ms, (IProgressMonitor)progress.split(1));
        return ms;
    }

    private IStatus removeMembers(IModuleResource[] all, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * all.length));
        int i = 0;
        while (i < all.length) {
            IPath relative;
            IPath published;
            IStatus s;
            SubMonitor recurse = sub.split(1);
            if (all[i] instanceof IModuleFolder) {
                IModuleResource[] children = ((IModuleFolder)all[i]).members();
                this.removeMembers(children, ms, (IProgressMonitor)recurse);
            }
            if ((s = this.fc.deleteResource(published = this.archiveDestination.append(relative = all[i].getModuleRelativePath()).append(all[i].getName()), (IProgressMonitor)sub.split(1))) != null && !s.isOK()) {
                ms.add(s);
            }
            ++i;
        }
        return ms;
    }

    private MultiStatus removeNestedSingleResourceBinary(MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IPath published = this.archiveDestinationWithName;
        IStatus s = this.fc.deleteResource(published, monitor);
        if (s != null && !s.isOK()) {
            ms.add(s);
        }
        return ms;
    }

    public MultiStatus removeDeletedBinaryModule(IProgressMonitor monitor) throws CoreException {
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 0, "Errors while deleting binary module " + this.module[this.module.length - 1].getName(), null);
        IModuleResource[] deleted = this.getAllResources(this.delta, 3, true);
        if (this.isNestedSingleResourceBinaryModule()) {
            this.removeNestedSingleResourceBinary(ms, monitor);
            return ms;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)deleted.length);
        int i = 0;
        while (i < deleted.length) {
            IPath relative = deleted[i].getModuleRelativePath();
            IPath published = this.archiveDestination.append(relative).append(deleted[i].getName());
            IStatus s = this.fc.deleteResource(published, (IProgressMonitor)subMonitor.split(1));
            if (s != null && !s.isOK()) {
                ms.add(s);
            }
            ++i;
        }
        return ms;
    }

    public MultiStatus publishModuleIncremental(IProgressMonitor monitor) throws CoreException {
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 0, "Errors while publishing binary module " + this.module[this.module.length - 1].getName(), null);
        if (this.isNestedSingleResourceBinaryModule()) {
            this.copyOneResourceSingleBinary(this.all[0], ms, monitor);
        } else {
            this.publishModuleIncremental(this.delta, ms, monitor);
        }
        return ms;
    }

    public void publishModuleIncremental(IModuleResourceDelta[] delta, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)delta.length);
        int i = 0;
        while (i < delta.length) {
            int kind = delta[i].getKind();
            IModuleResource mr = delta[i].getModuleResource();
            if (mr instanceof IModuleFile) {
                if (kind == 3) {
                    this.removeMembers(new IModuleResource[]{mr}, ms, (IProgressMonitor)sub.split(1));
                } else if (kind == 2 || kind == 1) {
                    this.copyOneResource(mr, ms, (IProgressMonitor)sub.split(1));
                }
            } else {
                IModuleResourceDelta[] children = delta[i].getAffectedChildren();
                SubMonitor folderMonitor = SubMonitor.convert((IProgressMonitor)sub.split(1), (int)2);
                this.publishModuleIncremental(children, ms, (IProgressMonitor)folderMonitor.split(1));
                if (kind == 3) {
                    this.removeMembers(new IModuleResource[]{mr}, ms, (IProgressMonitor)folderMonitor.split(1));
                }
            }
            ++i;
        }
    }

    public MultiStatus publishModuleFull(IProgressMonitor monitor) throws CoreException {
        boolean nested = this.isNestedSingleResourceBinaryModule();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        MultiStatus status = this.removeDeletedBinaryModule((IProgressMonitor)sub.split(1));
        if (nested) {
            this.copyOneResourceSingleBinary(this.all[0], status, (IProgressMonitor)sub.split(1));
        } else {
            this.publishModuleMembers(this.all, status, (IProgressMonitor)sub.split(1));
        }
        return status;
    }

    private boolean isNestedSingleResourceBinaryModule() {
        return this.module.length > 1 && this.all.length == 1 && this.all[0] instanceof IModuleFile;
    }

    private void publishModuleMembers(IModuleResource[] members, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)members.length);
        int i = 0;
        while (i < members.length) {
            IModuleResource mr = members[i];
            if (mr instanceof IModuleFolder) {
                IModuleResource[] children = ((IModuleFolder)mr).members();
                this.publishModuleMembers(children, ms, (IProgressMonitor)sub.split(1));
            } else {
                this.copyOneResource(mr, ms, (IProgressMonitor)sub.split(1));
            }
            ++i;
        }
    }

    private void copyOneResource(IModuleResource r, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        this.copyOneResource(r, r.getName(), ms, monitor);
    }

    private void copyOneResourceSingleBinary(IModuleResource r, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        this.copyOneResource(r, this.archiveDestinationWithName.lastSegment(), ms, monitor);
    }

    private void copyOneResource(IModuleResource r, String lastSegmentName, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        File f = ModuleResourceUtil.getFile(r);
        IPath folder = this.archiveDestination.append(r.getModuleRelativePath());
        IPath dest = folder.append(lastSegmentName);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IStatus result = this.fc.makeDirectoryIfRequired(folder, (IProgressMonitor)subMonitor.split(1));
        if (result == null || result.isOK()) {
            result = this.fc.copyFile(f, dest, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.setWorkRemaining(0);
        if (result != null) {
            ms.add(result);
        }
    }

    private IModuleResource[] getAllResources(IModuleResourceDelta[] delta, int kind, boolean depthFirst) {
        if (delta == null) {
            return new IModuleResource[0];
        }
        ArrayList<IModuleResource> list = new ArrayList<IModuleResource>();
        int i = 0;
        while (i < delta.length) {
            IModuleResource r = delta[i].getModuleResource();
            IModuleResourceDelta[] children = delta[i].getAffectedChildren();
            IModuleResource[] childrenRes = children != null ? this.getAllResources(children, kind, depthFirst) : new IModuleResource[]{};
            if (depthFirst) {
                list.addAll(Arrays.asList(childrenRes));
                if (delta[i].getKind() == kind) {
                    list.add(r);
                }
            } else {
                if (delta[i].getKind() == kind) {
                    list.add(r);
                }
                list.addAll(Arrays.asList(childrenRes));
            }
            ++i;
        }
        return list.toArray(new IModuleResource[list.size()]);
    }
}

