/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.core.internal.ansi;

import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.internal.ansi.AbstractCommand;
import org.jboss.tools.aesh.core.internal.ansi.CommandType;

public class CursorUp
extends AbstractCommand {
    private int amount = 1;

    public CursorUp(String arguments) {
        if (!"".equals(arguments)) {
            this.amount = Integer.parseInt(arguments);
        }
    }

    @Override
    public CommandType getType() {
        return CommandType.CURSOR_UP;
    }

    @Override
    public void handle(Document document) {
        int currentOffset = document.getCursorOffset();
        int currentLine = document.getLineOfOffset(currentOffset);
        int newLine = currentLine - this.amount;
        if (newLine >= 0) {
            int currentColumn = currentOffset - document.getLineOffset(currentLine);
            int newOffset = document.getLineOffset(newLine) + currentColumn;
            document.moveCursorTo(newOffset);
        }
    }
}

