/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.aesh.ui.internal.document;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.aesh.core.document.Document;
import org.jboss.tools.aesh.core.document.Style;
import org.jboss.tools.aesh.ui.internal.AeshUIPlugin;
import org.jboss.tools.aesh.ui.internal.document.CursorListener;
import org.jboss.tools.aesh.ui.internal.document.StyleImpl;
import org.jboss.tools.aesh.ui.internal.util.FontManager;
import org.jboss.tools.aesh.ui.internal.util.StyleRangeHelper;

public class DocumentImpl
implements Document {
    org.eclipse.jface.text.Document delegateDocument = new org.eclipse.jface.text.Document();
    StyleImpl currentStyle = StyleImpl.getDefault();
    CursorListener cursorListener;
    int savedCursor = 0;
    int cursorOffset = 0;
    IDocumentListener documentListener = null;

    public DocumentImpl() {
        this.initializeListener();
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    public int getLineOfOffset(int offset) {
        int result = -1;
        try {
            result = this.delegateDocument.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            AeshUIPlugin.log(e);
        }
        return result;
    }

    public int getLineOffset(int line) {
        int result = -1;
        try {
            result = this.delegateDocument.getLineOffset(line);
        }
        catch (BadLocationException e) {
            AeshUIPlugin.log(e);
        }
        return result;
    }

    public int getLineLength(int line) {
        int result = -1;
        try {
            result = this.delegateDocument.getLineLength(line);
        }
        catch (BadLocationException e) {
            AeshUIPlugin.log(e);
        }
        return result;
    }

    public void moveCursorTo(int offset) {
        this.cursorOffset = offset;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.cursorListener.cursorMoved();
            }
        });
    }

    public void reset() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.delegateDocument.set("");
            }
        });
        this.moveCursorTo(0);
        this.setDefaultStyle();
    }

    public int getLength() {
        return this.delegateDocument.getLength();
    }

    public void replace(final int pos, final int length, final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DocumentImpl.this.delegateDocument.replace(pos, length, text);
                }
                catch (BadLocationException e) {
                    AeshUIPlugin.log(e);
                }
            }
        });
    }

    public void restoreCursor() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.moveCursorTo(DocumentImpl.this.savedCursor);
            }
        });
    }

    public void saveCursor() {
        this.savedCursor = this.getCursorOffset();
    }

    public Style newStyleFromCurrent() {
        StyleRange oldStyleRange = this.currentStyle.getStyleRange();
        StyleRange newStyleRange = new StyleRange((TextStyle)oldStyleRange);
        newStyleRange.start = oldStyleRange.start + oldStyleRange.length;
        newStyleRange.length = 0;
        return new StyleImpl(newStyleRange);
    }

    public void setCurrentStyle(Style styleRangeProxy) {
        if (styleRangeProxy instanceof StyleImpl) {
            this.currentStyle = (StyleImpl)styleRangeProxy;
        }
    }

    public Style getCurrentStyle() {
        return this.currentStyle;
    }

    public void setDefaultStyle() {
        StyleImpl defaultStyle = StyleImpl.getDefault();
        StyleRange styleRange = defaultStyle.getStyleRange();
        styleRange.start = this.delegateDocument.getLength();
        styleRange.length = 0;
        this.setCurrentStyle(new StyleImpl(styleRange));
    }

    public org.eclipse.jface.text.Document getDelegate() {
        return this.delegateDocument;
    }

    public void setCursorListener(CursorListener listener) {
        this.cursorListener = listener;
    }

    public void setDocumentListener(IDocumentListener listener) {
        if (listener != this.documentListener) {
            if (this.documentListener != null) {
                this.delegateDocument.removeDocumentListener(this.documentListener);
                this.documentListener = null;
            }
            if (listener != null) {
                this.delegateDocument.addDocumentListener(listener);
                this.documentListener = listener;
            }
        }
    }

    private void initializeListener() {
        FontManager.INSTANCE.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                StyleRangeHelper.updateStyleRange(DocumentImpl.this.currentStyle.getStyleRange());
            }
        });
    }
}

