/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.catalog.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GeneratePluginXmlCatalog {
    private static ArrayList<String> errors = new ArrayList();
    private static ArrayList<XSDObject> xsdObjs = new ArrayList();
    private static ArrayList<DTDObject> dtObjs = new ArrayList();
    private static final String PLUGIN_ROOT_DIR = "plugin.root.dir";
    private static final String MODE = "output.mode";
    private static final String MODE_DEBUG = "showErrors";
    private static final String MODE_GENERATE = "generateCatalog";

    public static void main(String[] args) {
        String mode = System.getProperty(MODE);
        if (mode == null) {
            mode = MODE_GENERATE;
        }
        if (mode.equals(MODE_GENERATE)) {
            System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            System.out.println("<?eclipse version=\"3.2\"?>");
            System.out.println("<plugin>");
            System.out.println("   <extension");
            System.out.println("         point=\"org.eclipse.wst.xml.core.catalogContributions\">");
            System.out.println("       <catalogContribution>");
            System.out.println("<!-- DTDs -->");
            GeneratePluginXmlCatalog.runDTDs(true);
            System.out.println("\n\n<!-- XSD -->");
            GeneratePluginXmlCatalog.runXSDs(true);
            System.out.println("       </catalogContribution>");
            System.out.println("   </extension>");
            System.out.println("</plugin>");
        } else if (mode.equals(MODE_DEBUG)) {
            GeneratePluginXmlCatalog.runDTDs(false);
            GeneratePluginXmlCatalog.runXSDs(false);
            GeneratePluginXmlCatalog.runXSDErrors();
        } else {
            System.out.println("Usage: java -Dplugin.root.dir=/path/to/jbosstools-server/as/plugins/org.jboss.tools.as.catalog org.\\");
            System.out.println("       -Doutput.mode=[generateCatalog | showErrors]");
            System.out.println("       jboss.tools.as.catalog.internal.GeneratePluginXmlCatalog ");
        }
    }

    private static void runXSDErrors() {
        ArrayList<String> commonNamespaces = new ArrayList<String>();
        commonNamespaces.add("http://xmlns.jcp.org/xml/ns/javaee");
        commonNamespaces.add("http://java.sun.com/xml/ns/javaee");
        commonNamespaces.add("http://java.sun.com/xml/ns/j2ee");
        commonNamespaces.add("http://java.sun.com/xml/ns/j2ee");
        commonNamespaces.add("http://java.sun.com/xml/ns/persistence");
        HashMap<String, XSDObject> duplicateUriMap = new HashMap<String, XSDObject>();
        for (XSDObject o : xsdObjs) {
            String f2Name;
            String f1Name;
            if (duplicateUriMap.containsKey(o.getName()) && !(f1Name = ((XSDObject)duplicateUriMap.get((Object)o.getName())).file.getName()).equals(f2Name = o.file.getName()) && !commonNamespaces.contains(o.getName())) {
                System.err.println(String.valueOf(f1Name) + " is a duplicate with " + f2Name + " and has name " + o.getName());
            }
            duplicateUriMap.put(o.getName(), o);
        }
        Iterator<String> errIt = errors.iterator();
        while (errIt.hasNext()) {
            System.err.println(errIt.next());
        }
    }

    private static void runXSDs(boolean printEntries) {
        String rootdir = System.getProperty(PLUGIN_ROOT_DIR);
        if (rootdir == null) {
            rootdir = "";
        }
        File root = new File(new File(rootdir).getAbsolutePath());
        File schemas = new File(root, "schema");
        File xsd = new File(schemas, "xsd");
        List<File> all = Arrays.asList(xsd.listFiles());
        all.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File f : all) {
            if (f.getName().equalsIgnoreCase(".gitignore")) continue;
            XSDObject o = new XSDObject(f);
            if (o.valid) {
                xsdObjs.add(o);
                continue;
            }
            errors.add(f + " is invalid: " + (o.validException == null ? "null" : o.validException.getMessage()));
        }
        Collections.sort(xsdObjs, new Comparator<XSDObject>(){

            @Override
            public int compare(XSDObject o1, XSDObject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (printEntries) {
            for (XSDObject o : xsdObjs) {
                if (!o.valid) continue;
                System.out.println(o.toString());
            }
        }
    }

    private static void runDTDs(boolean printEntry) {
        String rootdir = System.getProperty(PLUGIN_ROOT_DIR);
        if (rootdir == null) {
            rootdir = "";
        }
        File root = new File(new File(rootdir).getAbsolutePath());
        File schemas = new File(root, "schema");
        File dtd = new File(schemas, "dtd");
        File[] dtdFiles = dtd.listFiles();
        List<File> sorted = Arrays.asList(dtdFiles);
        sorted.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File f : sorted) {
            try {
                GeneratePluginXmlCatalog.handleDTD(f);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (printEntry) {
            for (DTDObject o : dtObjs) {
                if (!o.isValid) continue;
                System.out.println(o.toString());
            }
        }
    }

    private static void handleDTD(File f) throws IOException {
        DTDObject o = new DTDObject(f);
        if (o.isValid()) {
            dtObjs.add(o);
        }
    }

    private static String getFileContents(File file) throws IOException {
        byte[] contents = GeneratePluginXmlCatalog.getBytesFromFile(file);
        return new String(contents);
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static class DTDObject {
        public String contents;
        public String toString;
        public boolean isValid = true;
        public String error = null;
        public File f;

        public DTDObject(File f) {
            try {
                this.f = f;
                this.contents = GeneratePluginXmlCatalog.getFileContents(f);
                this.checkValid();
            }
            catch (IOException ioe) {
                this.isValid = false;
            }
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getError() {
            return this.error;
        }

        private void checkValid() {
            int start = this.contents.indexOf("PUBLIC");
            if (start == -1) {
                String err;
                this.error = err = "Improper format: " + this.f.getAbsolutePath();
                this.isValid = false;
                return;
            }
            int publicOpenQuote = this.contents.indexOf("\"", start);
            int publicCloseQuote = this.contents.indexOf("\"", publicOpenQuote + 1);
            String publicString = this.contents.substring(publicOpenQuote + 1, publicCloseQuote);
            int webURLOpenQuote = this.contents.indexOf("\"", publicCloseQuote + 1);
            int webURLCloseQuote = this.contents.indexOf("\"", webURLOpenQuote + 1);
            String webURL = this.contents.substring(webURLOpenQuote + 1, webURLCloseQuote);
            String uri = "platform:/plugin/org.jboss.tools.as.catalog/schema/dtd/" + this.f.getName();
            StringBuffer sb = new StringBuffer();
            sb.append("\t\t\t<public publicId=\"");
            sb.append(publicString);
            sb.append("\"\n\t\t\t\turi=\"");
            sb.append(uri);
            sb.append("\"/>\n");
            sb.append("\t\t\t<system systemId=\"");
            sb.append(webURL);
            sb.append("\"\n\t\t\t\turi=\"");
            sb.append(uri);
            sb.append("\"/>\n");
            this.toString = sb.toString();
        }

        public String toString() {
            return this.toString;
        }
    }

    private static class XSDObject {
        String contents = null;
        File file = null;
        boolean valid = true;
        Exception validException = null;
        String uri = null;

        public XSDObject(File f) {
            try {
                this.file = f;
                this.contents = GeneratePluginXmlCatalog.getFileContents(f);
                this.toString();
            }
            catch (IOException ioe) {
                this.valid = false;
                this.validException = ioe;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\t\t<uri name=\"");
            sb.append(this.getName());
            sb.append("\" uri=\"");
            sb.append(this.getUri());
            sb.append("\"/>");
            return sb.toString();
        }

        String getUri() {
            return "platform:/plugin/org.jboss.tools.as.catalog/schema/xsd/" + this.file.getName();
        }

        String getName() {
            if (this.uri != null) {
                return this.uri;
            }
            int start = this.contents.indexOf("targetNamespace=\"");
            if (start == -1) {
                start = this.contents.indexOf("xmlns=\"");
            }
            if (start == -1) {
                this.valid = false;
                return "";
            }
            int subStart = this.contents.indexOf("\"", start);
            int subEnd = this.contents.indexOf("\"", subStart + 1);
            this.uri = this.contents.substring(subStart + 1, subEnd);
            if ("http://www.jboss.com/xml/ns/javaee".equals(this.uri)) {
                this.uri = "http://www.jboss.org/j2ee/schema/" + this.file.getName();
            }
            return this.uri;
        }
    }
}

