/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchUtil {
    private static File TEMPLATE_FOLDER;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void scanXMLFile(IFile file, DocumentScanner scanner) {
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) return;
        IStructuredModel model = null;
        try {
            try {
                IDOMModel domModel;
                IDOMDocument document;
                model = manager.getModelForRead(file);
                if (!(model instanceof IDOMModel) || (document = (domModel = (IDOMModel)model).getDocument()) == null) return;
                scanner.scanDocument((Document)document);
                return;
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError((Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static List<TextSourceReference> getAttributeReferences(IFile file, String name, String value) {
        String expression = "//*[@" + name + "=\"" + value + "\"]/@" + name;
        AttrReferencesRequestor<TextSourceReference> requestor = new AttrReferencesRequestor<TextSourceReference>(file, expression, TextSourceReference.class);
        BatchUtil.scanXMLFile(file, requestor);
        return requestor.results;
    }

    public static List<TextSourceReference> getPropertyAttributeReferences(IFile file, String refValue, String propertyName) {
        String expression = "//*[@ref=\"" + refValue + "\"]//*[@" + "name" + "=\"" + propertyName + "\"]/@" + "name";
        AttrReferencesRequestor<TextSourceReference> requestor = new AttrReferencesRequestor<TextSourceReference>(file, expression, TextSourceReference.class);
        BatchUtil.scanXMLFile(file, requestor);
        return requestor.results;
    }

    public static List<NodePathTextSourceReference> getNodePathPropertyAttributeReferences(IFile file, String refValue, String propertyName) {
        String expression = "//*[@ref=\"" + refValue + "\"]//*[@" + "name" + "=\"" + propertyName + "\"]/@" + "name";
        AttrReferencesRequestor<NodePathTextSourceReference> requestor = new AttrReferencesRequestor<NodePathTextSourceReference>(file, expression, NodePathTextSourceReference.class);
        BatchUtil.scanXMLFile(file, requestor);
        return requestor.results;
    }

    private static List<KbQuery.Tag> getNodePath(Node node) {
        ArrayList<KbQuery.Tag> tags = new ArrayList<KbQuery.Tag>();
        Node n = node;
        if (n instanceof AttrImpl) {
            n = ((AttrImpl)node).getOwnerElement();
        }
        while (!(n instanceof IDOMDocument) && n != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (n.hasAttributes()) {
                NamedNodeMap attrs = n.getAttributes();
                int index = 0;
                while (index < attrs.getLength()) {
                    Node attribute = attrs.item(index);
                    attributes.put(attribute.getNodeName(), attribute.getNodeValue());
                    ++index;
                }
            }
            KbQuery.Tag tag = new KbQuery.Tag(n.getNodeName(), attributes);
            tags.add(tag);
            n = n.getParentNode();
        }
        return tags;
    }

    public static File getTemplatesFolder() throws IOException {
        if (TEMPLATE_FOLDER == null) {
            Bundle bundle = BatchCorePlugin.getDefault().getBundle();
            String version = bundle.getVersion().toString();
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File templatesDir = FileLocator.getBundleFile((Bundle)bundle);
            if (templatesDir.isFile()) {
                File toCopy = new File(stateLocation.toFile(), version);
                if (!toCopy.exists()) {
                    toCopy.mkdirs();
                    UnzipOperation unZip = new UnzipOperation(templatesDir.getAbsolutePath());
                    unZip.execute(toCopy, "templates.*");
                }
                templatesDir = toCopy;
            }
            TEMPLATE_FOLDER = new File(templatesDir, "templates");
        }
        return TEMPLATE_FOLDER;
    }

    public static IPath getBatchXMLPath(IProject p) {
        IPath result = null;
        IResource[] iResourceArray = EclipseUtil.getJavaSourceRoots((IProject)p);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource f = iResourceArray[n2];
            if (f instanceof IFolder) {
                IFolder fm = ((IFolder)f).getFolder("META-INF");
                IFile batch = fm.getFile("batch.xml");
                if (batch.exists()) {
                    return batch.getFullPath();
                }
                if (result == null || fm.exists()) {
                    result = batch.getFullPath();
                }
            }
            ++n2;
        }
        return result;
    }

    public static class AttrReferencesRequestor<E extends TextSourceReference>
    implements DocumentScanner {
        IFile file;
        String expression;
        List<E> results = new ArrayList();
        Class<E> cls;

        public AttrReferencesRequestor(IFile file, String expression, Class<E> cls) {
            this.file = file;
            this.expression = expression;
            this.cls = cls;
        }

        @Override
        public void scanDocument(Document document) {
            block8: {
                XPath xPath = XPathFactory.newInstance().newXPath();
                try {
                    Object result = xPath.compile(this.expression).evaluate(document, XPathConstants.NODESET);
                    if (!(result instanceof NodeList)) break block8;
                    NodeList list = (NodeList)result;
                    int i = 0;
                    while (i < list.getLength()) {
                        Node n = list.item(i);
                        if (n instanceof AttrImpl) {
                            AttrImpl a = (AttrImpl)n;
                            int start0 = a.getValueRegionStartOffset();
                            int length0 = a.getValueRegionText().length();
                            if (a.getValueRegionText().startsWith("\"")) {
                                length0 -= 2;
                            }
                            int start = ++start0;
                            int length = length0;
                            try {
                                TextSourceReference ref = (TextSourceReference)this.cls.newInstance();
                                ref.setLength(length);
                                ref.setResource((IResource)this.file);
                                ref.setStartPosition(start);
                                ref.setNodePath(n);
                                this.results.add(ref);
                            }
                            catch (InstantiationException instantiationException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {}
                        }
                        ++i;
                    }
                }
                catch (XPathExpressionException e) {
                    BatchCorePlugin.pluginLog().logError((Throwable)e);
                }
            }
        }

        public List<E> getResults() {
            return this.results;
        }
    }

    public static interface DocumentScanner {
        public void scanDocument(Document var1);
    }

    public static class NodePathTextSourceReference
    extends TextSourceReference {
        private List<KbQuery.Tag> tags;

        public Collection<KbQuery.Tag> getNodePath() {
            return this.tags;
        }

        @Override
        public void setNodePath(Node node) {
            this.tags = BatchUtil.getNodePath(node);
        }
    }

    public static class TextSourceReference
    implements ITextSourceReference {
        private IResource resource;
        int startPosition;
        int length;

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getLength() {
            return this.length;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public void setStartPosition(int startPosition) {
            this.startPosition = startPosition;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setNodePath(Node node) {
        }
    }
}

