/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.batch.core.IRootDefinitionContext;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.definition.BatchJobDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.BatchXMLDefinition;
import org.jboss.tools.batch.internal.core.impl.definition.Dependencies;
import org.jboss.tools.batch.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.EclipseUtil;

public class DefinitionContext
implements IRootDefinitionContext {
    protected BatchProject project;
    protected IJavaProject javaProject;
    private Set<String> types = new HashSet<String>();
    private Map<IPath, Set<IPath>> childPaths = new HashMap<IPath, Set<IPath>>();
    private Map<IPath, Set<String>> resources = new HashMap<IPath, Set<String>>();
    private Map<String, TypeDefinition> typeDefinitions = new HashMap<String, TypeDefinition>();
    private Map<IPath, BatchJobDefinition> batchJobs = new HashMap<IPath, BatchJobDefinition>();
    private Map<IPath, BatchXMLDefinition> batchXMLs = new HashMap<IPath, BatchXMLDefinition>();
    private Dependencies dependencies = new Dependencies();
    private DefinitionContext workingCopy;
    private DefinitionContext original;

    private synchronized DefinitionContext copy(boolean clean) {
        DefinitionContext copy = new DefinitionContext();
        copy.project = this.project;
        copy.javaProject = this.javaProject;
        if (!clean) {
            HashSet<String> s1;
            Set<String> set;
            copy.types.addAll(this.types);
            copy.typeDefinitions.putAll(this.typeDefinitions);
            copy.batchJobs.putAll(this.batchJobs);
            copy.batchXMLs.putAll(this.batchXMLs);
            for (IPath p : this.resources.keySet()) {
                set = this.resources.get(p);
                if (set == null) continue;
                s1 = new HashSet<String>();
                s1.addAll(set);
                copy.resources.put(p, s1);
            }
            for (IPath p : this.childPaths.keySet()) {
                set = this.childPaths.get(p);
                if (set == null) continue;
                s1 = new HashSet();
                s1.addAll(set);
                copy.childPaths.put(p, s1);
            }
        }
        return copy;
    }

    public void setProject(BatchProject project) {
        this.project = project;
        this.javaProject = EclipseUtil.getJavaProject((IProject)project.getProject());
    }

    @Override
    public BatchProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addType(IPath file, String typeName, TypeDefinition def) {
        this.addType(file, typeName);
        if (def != null) {
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                this.typeDefinitions.put(def.getQualifiedName(), def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatchConfig(BatchJobDefinition def) {
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            this.batchJobs.put(def.getPath(), def);
        }
        this.addToParents(def.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatchXML(BatchXMLDefinition def) {
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            this.batchXMLs.put(def.getPath(), def);
        }
        this.addToParents(def.getPath());
    }

    @Override
    public synchronized void addType(IPath file, String typeName) {
        if (file != null) {
            Set<String> ts = this.resources.get(file);
            if (ts == null) {
                ts = new HashSet<String>();
                this.resources.put(file, ts);
            }
            ts.add(typeName);
            this.types.add(typeName);
            this.addToParents(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToParents(IPath file) {
        if (file == null) {
            return;
        }
        if (file.segmentCount() < 2) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            q = q.removeLastSegments(1);
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                Set<IPath> cs = this.childPaths.get(q);
                if (cs == null) {
                    cs = new HashSet<IPath>();
                    this.childPaths.put(q, cs);
                }
                cs.add(file);
            }
        }
    }

    @Override
    public synchronized void clean() {
        this.childPaths.clear();
        this.resources.clear();
        this.types.clear();
        this.batchJobs.clear();
        this.batchXMLs.clear();
        this.typeDefinitions.clear();
    }

    @Override
    public synchronized void clean(IPath path) {
        Set<String> ts = this.resources.remove(path);
        if (ts != null) {
            for (String t : ts) {
                this.clean(t);
            }
        }
        this.batchJobs.remove(path);
        this.batchXMLs.remove(path);
        Set<IPath> cs = this.childPaths.get(path);
        if (cs != null) {
            IPath[] ps;
            IPath[] iPathArray = ps = cs.toArray(new IPath[0]);
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IPath p = iPathArray[n2];
                this.clean(p);
                ++n2;
            }
        } else {
            this.removeFromParents(path);
        }
    }

    @Override
    public synchronized void clean(String typeName) {
        this.types.remove(typeName);
        this.typeDefinitions.remove(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromParents(IPath file) {
        if (file == null) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            q = q.removeLastSegments(1);
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                Set<IPath> cs = this.childPaths.get(q);
                if (cs != null) {
                    cs.remove(file);
                    if (cs.isEmpty()) {
                        this.childPaths.remove(q);
                    }
                }
            }
        }
    }

    @Override
    public void newWorkingCopy(boolean forFullBuild) {
        if (this.original != null) {
            return;
        }
        this.workingCopy = this.copy(forFullBuild);
        this.workingCopy.original = this;
    }

    @Override
    public DefinitionContext getWorkingCopy() {
        if (this.original != null) {
            return this;
        }
        if (this.workingCopy != null) {
            return this.workingCopy;
        }
        this.workingCopy = this.copy(false);
        this.workingCopy.original = this;
        return this.workingCopy;
    }

    @Override
    public void applyWorkingCopy() {
        if (this.original != null) {
            this.original.applyWorkingCopy();
            return;
        }
        if (this.workingCopy == null) {
            return;
        }
        HashSet<TypeDefinition> newTypeDefinitions = new HashSet<TypeDefinition>();
        for (String typeName : this.workingCopy.typeDefinitions.keySet()) {
            TypeDefinition nd = this.workingCopy.typeDefinitions.get(typeName);
            TypeDefinition od = this.typeDefinitions.get(typeName);
            if (od == nd) continue;
            newTypeDefinitions.add(nd);
        }
        this.types = this.workingCopy.types;
        this.resources = this.workingCopy.resources;
        this.childPaths = this.workingCopy.childPaths;
        this.typeDefinitions = this.workingCopy.typeDefinitions;
        this.batchJobs = this.workingCopy.batchJobs;
        this.batchXMLs = this.workingCopy.batchXMLs;
        this.project.update(true);
        this.workingCopy = null;
    }

    public void dropWorkingCopy() {
        if (this.original != null) {
            this.original.dropWorkingCopy();
        } else {
            this.workingCopy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypeDefinition> getTypeDefinitions() {
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.typeDefinitions.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BatchJobDefinition> getBatchJobDefinitions() {
        HashSet<BatchJobDefinition> result = new HashSet<BatchJobDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.batchJobs.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BatchXMLDefinition> getBatchXMLDefinitions() {
        HashSet<BatchXMLDefinition> result = new HashSet<BatchXMLDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.batchXMLs.values());
        }
        return result;
    }

    public synchronized TypeDefinition getTypeDefinition(String fullyQualifiedName) {
        return this.typeDefinitions.get(fullyQualifiedName);
    }

    @Override
    public void addDependency(IPath source, IPath target) {
        this.dependencies.addDependency(source, target);
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }
}

