/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl.definition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IRootDefinitionContext;
import org.jboss.tools.batch.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.util.FileUtil;

public class AbstractTypeDefinition
extends AbstractMemberDefinition {
    protected String qualifiedName;
    protected IType type;
    protected ParametedType parametedType = null;

    @Override
    public AbstractTypeDefinition getTypeDefinition() {
        return this;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType type, IRootDefinitionContext context, int flags) {
        super.setAnnotatable((IAnnotatable)type, type, context, flags);
    }

    @Override
    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        this.type = contextType;
        super.init(contextType, context, flags);
        this.qualifiedName = this.getType().getFullyQualifiedName();
        this.resetParametedType();
    }

    public ParametedType getParametedType() {
        return this.parametedType;
    }

    public void resetParametedType() {
        this.parametedType = this.project.getTypeFactory().newParametedType(this.type);
        if (this.type != null && !this.type.isBinary()) {
            this.parametedType.setPositionProvider((ParametedType.PositionProvider)new PositionProviderImpl());
            this.parametedType.getInheritedTypes();
        }
    }

    public void setParametedType(IParametedType t) {
        this.parametedType = (ParametedType)t;
    }

    public Collection<IParametedType> getInheritedTypes() {
        if (this.parametedType == null) {
            return Collections.emptyList();
        }
        return this.parametedType.getInheritedTypes();
    }

    public Collection<IParametedType> getAllTypes() {
        if (this.parametedType == null) {
            return Collections.emptyList();
        }
        return this.parametedType.getAllTypes();
    }

    public String getKey() {
        String result = this.getQualifiedName();
        if (this.originalDefinition != null) {
            result = String.valueOf(result) + ":" + this.originalDefinition.getStartPosition() + ":" + this.originalDefinition.getLength();
        }
        return result;
    }

    public String getContent() {
        if (this.type == null || this.type.isBinary()) {
            return null;
        }
        IResource resource = this.getResource();
        if (resource instanceof IFile && resource.getName().toLowerCase().endsWith(".java")) {
            return FileUtil.getContentFromEditorOrFile((IFile)((IFile)resource));
        }
        return null;
    }

    class PositionProviderImpl
    implements ParametedType.PositionProvider {
        Map<String, ISourceRange> map = null;

        PositionProviderImpl() {
        }

        void init() throws CoreException {
            String[] is;
            this.map = new HashMap<String, ISourceRange>();
            String content = AbstractTypeDefinition.this.getContent();
            if (content == null) {
                return;
            }
            ISourceRange r = AbstractTypeDefinition.this.type.getNameRange();
            if (r == null) {
                return;
            }
            int b = r.getOffset() + r.getLength();
            if (b < 0) {
                return;
            }
            int e = content.indexOf(123, b);
            if (e < 0) {
                e = content.length();
            }
            if (e < b) {
                return;
            }
            String sup = content.substring(b, e);
            String sc = AbstractTypeDefinition.this.type.getSuperclassName();
            if (sc != null) {
                this.checkRange(b, sup, sc);
            }
            if ((is = AbstractTypeDefinition.this.type.getSuperInterfaceNames()) != null) {
                int i = 0;
                while (i < is.length) {
                    this.checkRange(b, sup, is[i]);
                    ++i;
                }
            }
        }

        void checkRange(int offset, String sup, String sc) {
            int k = sup.indexOf(sc);
            if (k >= 0) {
                this.map.put(sc, (ISourceRange)new SourceRange(offset + k, sc.length()));
            }
        }

        public boolean isLoaded() {
            return this.map != null;
        }

        public ISourceRange getRange(String superTypeName) {
            if (this.map == null) {
                try {
                    this.init();
                }
                catch (CoreException e) {
                    BatchCorePlugin.pluginLog().logError((Throwable)e);
                }
            }
            return this.map.get(superTypeName);
        }
    }
}

