/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.batch.core.BatchConstants;
import org.jboss.tools.batch.internal.core.preferences.BatchSeverityPreferences;
import org.jboss.tools.batch.internal.core.validation.BatchValidationMessages;
import org.jboss.tools.batch.internal.core.validation.BatchValidator;
import org.jboss.tools.batch.internal.core.validation.JobTransitionsValidator;
import org.jboss.tools.batch.internal.core.validation.SimpleReference;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class TransitionsValidator
implements BatchConstants {
    JobTransitionsValidator jobTransitions;
    BatchValidator validator;
    Map<String, FlowNode> flowElements = new HashMap<String, FlowNode>();

    public TransitionsValidator(BatchValidator validator, JobTransitionsValidator jobLevel) {
        this.validator = validator;
        this.jobTransitions = jobLevel;
    }

    public String addFlowElement(Element element) {
        String id = element.getAttribute("id").trim();
        if (id.length() > 0) {
            FlowNode n = new FlowNode(element);
            if (!this.flowElements.containsKey(id)) {
                this.flowElements.put(id, n);
            }
        }
        return id;
    }

    public void validate(IFile file) {
        String fromNodeId;
        for (FlowNode n : this.flowElements.values()) {
            Element nextElement;
            fromNodeId = n.getIDValue();
            this.validateTransitionAttribute(n.element, fromNodeId, "next", file);
            Element[] elementArray = XMLUtilities.getChildren((Element)n.element, (String)"next");
            int n2 = elementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                nextElement = elementArray[n3];
                this.validateTransitionAttribute(nextElement, fromNodeId, "to", file);
                ++n3;
            }
            elementArray = XMLUtilities.getChildren((Element)n.element, (String)"stop");
            n2 = elementArray.length;
            n3 = 0;
            while (n3 < n2) {
                nextElement = elementArray[n3];
                this.validateRestartAttribute(nextElement, fromNodeId, file);
                ++n3;
            }
        }
        while (this.reduce() > 0) {
        }
        for (FlowNode n : this.flowElements.values()) {
            fromNodeId = n.getIDValue();
            for (FlowLink link : n.out) {
                String toNodeId = link.toNodeId;
                SimpleReference ref = new SimpleReference(link.attr.getOwnerElement(), link.attr.getName(), file);
                this.validator.addProblem(BatchValidationMessages.LOOP_IS_DETECTED, BatchSeverityPreferences.LOOP_IS_DETECTED, new String[]{fromNodeId, toNodeId}, ref.getLength(), ref.getStartPosition(), (IResource)file);
            }
        }
    }

    void validateTransitionAttribute(Element fromElement, String fromNodeId, String attrName, IFile file) {
        String toNodeId;
        Attr next = fromElement.getAttributeNode(attrName);
        if (next != null && (toNodeId = fromElement.getAttribute(attrName).trim()).length() > 0) {
            if (this.flowElements.get(toNodeId) == null) {
                this.validator.addProblem(BatchValidationMessages.TARGET_NOT_FOUND, BatchSeverityPreferences.TARGET_NOT_FOUND, fromElement, attrName, file, -1);
            } else if (toNodeId.equals(fromNodeId)) {
                this.validator.addProblem(BatchValidationMessages.TRANSITION_TO_SELF, BatchSeverityPreferences.LOOP_IS_DETECTED, fromElement, attrName, file, -1);
            } else {
                FlowLink link = new FlowLink(fromNodeId, next, toNodeId);
                this.flowElements.get((Object)fromNodeId).out.add(link);
                this.flowElements.get((Object)toNodeId).in.add(link);
            }
        }
    }

    void validateRestartAttribute(Element fromElement, String fromNodeId, IFile file) {
        String toNodeId;
        Attr next = fromElement.getAttributeNode("restart");
        if (next != null && (toNodeId = fromElement.getAttribute("restart").trim()).length() > 0 && !this.jobTransitions.ids.contains(toNodeId)) {
            this.validator.addProblem(BatchValidationMessages.TARGET_NOT_FOUND_ON_JOB_LEVEL, BatchSeverityPreferences.TARGET_NOT_FOUND, fromElement, "restart", file, -1);
        }
    }

    private int reduce() {
        String[] ids = this.flowElements.keySet().toArray(new String[0]);
        int removedLinks = 0;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            FlowNode n3 = this.flowElements.get(id);
            if (n3.in.isEmpty()) {
                for (FlowLink link : n3.out) {
                    FlowNode to = this.flowElements.get(link.toNodeId);
                    if (to == null || !to.in.remove(link)) continue;
                    ++removedLinks;
                }
                this.flowElements.remove(id);
            } else if (n3.out.isEmpty()) {
                for (FlowLink link : n3.in) {
                    FlowNode from = this.flowElements.get(link.fromNodeId);
                    if (from == null || !from.out.remove(link)) continue;
                    ++removedLinks;
                }
                this.flowElements.remove(id);
            }
            ++n2;
        }
        return removedLinks;
    }

    static class FlowLink {
        String fromNodeId;
        String toNodeId;
        Attr attr;

        public FlowLink(String fromNodeId, Attr attr, String toNodeId) {
            this.fromNodeId = fromNodeId;
            this.toNodeId = toNodeId;
            this.attr = attr;
        }
    }

    static class FlowNode {
        Element element;
        Attr id;
        Set<FlowLink> in = new HashSet<FlowLink>();
        Set<FlowLink> out = new HashSet<FlowLink>();

        public FlowNode(Element element) {
            this.element = element;
            this.id = element.getAttributeNode("id");
        }

        public String getIDValue() {
            return this.element.getAttribute("id").trim();
        }
    }
}

