/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.editor.internal.model.Batchlet;
import org.jboss.tools.batch.ui.editor.internal.model.BatchletOrChunk;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.util.ModelToBatchArtifactsMapping;
import org.jboss.tools.batch.ui.internal.wizard.BatchFieldEditorFactory;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactDialog;
import org.jboss.tools.batch.ui.internal.wizard.WizardMessages;
import org.jboss.tools.common.EclipseUtil;

public class OpenOrCreateArtifactActionDelegate
implements Runnable {
    private SapphirePart part;
    private IBatchProject batchProject;
    private RefAttributeElement refElement;
    private String ref;
    private List<BatchArtifactType> types;
    private String artifactTypeName = null;

    public OpenOrCreateArtifactActionDelegate(SapphirePart part) {
        this.part = part;
        this.init();
    }

    public void init() {
        Step e;
        ElementList<BatchletOrChunk> ch;
        Element element = this.part.getLocalModelElement();
        IProject project = (IProject)element.resource().adapt(IProject.class);
        if (!(element instanceof RefAttributeElement) || project == null) {
            return;
        }
        this.batchProject = BatchCorePlugin.getBatchProject((IProject)project, (boolean)true);
        if (this.batchProject == null) {
            return;
        }
        this.refElement = (RefAttributeElement)element;
        this.ref = (String)this.refElement.getRef().content();
        this.types = ModelToBatchArtifactsMapping.getBatchArtifactTypes(((Element)this.refElement).type().getModelElementClass());
        if (this.types.size() > 1 && !(ch = (e = (Step)((Element)this.refElement).parent().element()).getBatchletOrChunk()).isEmpty() && ch.get(0) instanceof Batchlet) {
            this.types = new ArrayList<BatchArtifactType>();
            this.types.add(BatchArtifactType.STEP_LISTENER);
        }
        this.artifactTypeName = this.types.size() == 1 ? BatchFieldEditorFactory.getArtifactLabel(this.types.get(0)) : WizardMessages.aChunkStepListenerLabel;
        if (this.artifactTypeName != null) {
            this.artifactTypeName = this.artifactTypeName.toLowerCase();
        }
    }

    public SapphirePart getPart() {
        return this.part;
    }

    public IBatchProject getBatchProject() {
        return this.batchProject;
    }

    public String getActionLabel() {
        if (this.batchProject == null) {
            return "";
        }
        Collection artifacts = this.batchProject.getArtifacts(this.ref);
        return artifacts.isEmpty() ? NLS.bind((String)WizardMessages.actionCreateArtifact, (Object)this.artifactTypeName) : NLS.bind((String)WizardMessages.actionOpenArtifact, (Object)this.artifactTypeName);
    }

    @Override
    public void run() {
        if (this.batchProject == null) {
            return;
        }
        Collection artifacts = this.batchProject.getArtifacts(this.ref);
        if (artifacts.isEmpty()) {
            boolean artifactNameCanBeModified;
            int result;
            IResource[] rs;
            IWorkbench workbench = BatchUIPlugin.getDefault().getWorkbench();
            NewBatchArtifactDialog dialog = new NewBatchArtifactDialog(workbench.getActiveWorkbenchWindow().getShell());
            if (this.types.size() > 0) {
                dialog.setTypes(this.types);
            }
            if ((rs = EclipseUtil.getJavaSourceRoots((IProject)this.batchProject.getProject())).length == 0) {
                return;
            }
            StructuredSelection selection = new StructuredSelection((Object)rs[0]);
            dialog.init(workbench, (IStructuredSelection)selection);
            String typeName = null;
            if (this.ref != null && this.ref.length() > 0 && Character.isJavaIdentifierStart(this.ref.charAt(0))) {
                typeName = String.valueOf(this.ref.substring(0, 1).toUpperCase()) + this.ref.substring(1);
            }
            if ((result = dialog.open(this.batchProject, this.ref, artifactNameCanBeModified = this.ref == null || this.ref.length() == 0, this.types, this.types.size() > 1, typeName)) == 0) {
                String newRef = dialog.getBatchPage().getArtifactName();
                if (this.ref != null && !this.ref.equals(newRef)) {
                    this.refElement.setRef(newRef);
                } else {
                    this.refElement.setRef("");
                    this.refElement.setRef(newRef);
                }
            }
        } else {
            IBatchArtifact a = (IBatchArtifact)artifacts.iterator().next();
            try {
                JavaUI.openInEditor((IJavaElement)a.getType());
            }
            catch (PartInitException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
            catch (JavaModelException e) {
                BatchCorePlugin.pluginLog().logError((Throwable)e);
            }
        }
    }

    public void dispose() {
        this.batchProject = null;
        this.part = null;
        this.refElement = null;
    }
}

