/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.hyperlink.BatchPropertyHyperlink;

public class BatchPropertyHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected IFile file;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IJavaElement[] elements;
        BatchProject batchProject;
        IRegion wordRegion;
        IDocument document;
        ITypeRoot input;
        block12: {
            new ArrayList();
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (region == null || !(textEditor instanceof JavaEditor)) {
                return null;
            }
            if (textEditor.getEditorInput() instanceof IFileEditorInput) {
                this.file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
            }
            int offset = region.getOffset();
            input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)true);
            if (input == null) {
                return null;
            }
            document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
            if (wordRegion == null) {
                return null;
            }
            IProject project = input.getJavaProject().getProject();
            batchProject = (BatchProject)BatchProjectFactory.getBatchProjectWithProgress((IProject)project);
            if (batchProject == null) {
                return null;
            }
            elements = null;
            elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if (elements.length == 1) break block12;
            return null;
        }
        try {
            IBatchProperty property;
            IType type;
            IBatchArtifact artifact;
            ArrayList<BatchPropertyHyperlink> hyperlinks = new ArrayList<BatchPropertyHyperlink>();
            IField field = null;
            if (elements[0] instanceof IType) {
                elements[0] = input.getElementAt(wordRegion.getOffset());
            }
            if (elements[0] instanceof IField) {
                field = (IField)elements[0];
            }
            if (field != null && (artifact = batchProject.getArtifact(type = field.getDeclaringType())) != null && (property = artifact.getProperty(field)) != null) {
                hyperlinks.add(new BatchPropertyHyperlink(region, property, document));
            }
            if (hyperlinks != null && !hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        catch (JavaModelException jme) {
            BatchUIPlugin.getDefault().logError(jme);
        }
        return null;
    }
}

