/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.quickfixes.BatchQuickFixMessages;
import org.jboss.tools.batch.ui.quickfixes.CreateBatchArtifactQuickFix;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.quickfix.AbstractQuickFixGenerator;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;

public class BatchQuickFixGenerator
extends AbstractQuickFixGenerator {
    public boolean hasProposals(Annotation annotation, Position position) {
        return annotation instanceof TemporaryAnnotation;
    }

    public IJavaCompletionProposal[] getProposals(Annotation annotation, Position position) {
        if (annotation instanceof TemporaryAnnotation) {
            TemporaryAnnotation tempAnnotation = (TemporaryAnnotation)annotation;
            IFile file = MarkerResolutionUtils.getFile();
            if (file != null) {
                int messageId = this.getMessageID(tempAnnotation);
                int start = tempAnnotation.getPosition().getOffset();
                int end = start + tempAnnotation.getPosition().getLength();
                try {
                    return this.findXMLResolutions(file, messageId, start, end, true);
                }
                catch (JavaModelException e) {
                    BatchUIPlugin.getDefault().logError(e);
                }
            }
        }
        return new IJavaCompletionProposal[0];
    }

    protected IMarkerResolution[] findResolutions(IMarker marker) throws CoreException {
        int messageId = this.getMessageID(marker);
        if (messageId == -1) {
            return new IMarkerResolution[0];
        }
        if (marker.getResource() instanceof IFile) {
            IFile file = (IFile)marker.getResource();
            Integer attribute = (Integer)marker.getAttribute("charStart");
            if (attribute == null) {
                return new IMarkerResolution[0];
            }
            int start = attribute;
            attribute = (Integer)marker.getAttribute("charEnd");
            if (attribute == null) {
                return new IMarkerResolution[0];
            }
            int end = attribute;
            if ("xml".equals(file.getFileExtension())) {
                return this.findXMLResolutions(file, messageId, start, end, false);
            }
        }
        return new IMarkerResolution[0];
    }

    private IQuickFix[] findXMLResolutions(IFile file, int messageId, int start, int end, boolean asYouType) throws JavaModelException {
        String text;
        IJavaProject javaProject;
        block21: {
            javaProject = EclipseUtil.getJavaProject((IProject)file.getProject());
            FileEditorInput input = new FileEditorInput(file);
            IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
            text = "";
            try {
                provider.connect((Object)input);
                IDocument document = provider.getDocument((Object)input);
                text = document.get(start, end - start);
            }
            catch (BadLocationException e) {
                BatchUIPlugin.getDefault().logError(e);
                provider.disconnect((Object)input);
                break block21;
            }
            catch (CoreException e) {
                try {
                    BatchUIPlugin.getDefault().logError(e);
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    provider.disconnect((Object)input);
                }
            }
            provider.disconnect((Object)input);
        }
        if (text.startsWith("\"") || text.startsWith("'")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"") || text.endsWith("'")) {
            text = text.substring(0, text.length() - 1);
        }
        if (messageId == 1) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.BATCHLET, NLS.bind((String)BatchQuickFixMessages.CREATE_BATCHLET, (Object)text));
        }
        if (messageId == 2) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.JOB_LISTENER, NLS.bind((String)BatchQuickFixMessages.CREATE_JOB_LISTENER, (Object)text));
        }
        if (messageId == 3) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.STEP_LISTENER, NLS.bind((String)BatchQuickFixMessages.CREATE_STEP_LISTENER, (Object)text));
        }
        if (messageId == 4) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.DECIDER, NLS.bind((String)BatchQuickFixMessages.CREATE_DECIDER, (Object)text));
        }
        if (messageId == 5) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.CHECKPOINT_ALGORITHM, NLS.bind((String)BatchQuickFixMessages.CREATE_CHECKPOINT_ALGORYTHM, (Object)text));
        }
        if (messageId == 6) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.ITEM_READER, NLS.bind((String)BatchQuickFixMessages.CREATE_ITEM_READER, (Object)text));
        }
        if (messageId == 7) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.ITEM_WRITER, NLS.bind((String)BatchQuickFixMessages.CREATE_ITEM_WRITER, (Object)text));
        }
        if (messageId == 8) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.ITEM_PROCESSOR, NLS.bind((String)BatchQuickFixMessages.CREATE_ITEM_PROCESSOR, (Object)text));
        }
        if (messageId == 9) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.PARTITION_MAPPER, NLS.bind((String)BatchQuickFixMessages.CREATE_PARTITION_MAPPER, (Object)text));
        }
        if (messageId == 10) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.PARTITION_ANALYZER, NLS.bind((String)BatchQuickFixMessages.CREATE_PARTITION_ANALYZER, (Object)text));
        }
        if (messageId == 11) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.PARTITION_COLLECTOR, NLS.bind((String)BatchQuickFixMessages.CREATE_PARTITION_COLLECTOR, (Object)text));
        }
        if (messageId == 12) {
            return this.getQuickFixes(file, javaProject, text, BatchArtifactType.PARTITION_REDUCER, NLS.bind((String)BatchQuickFixMessages.CREATE_PARTITION_REDUCER, (Object)text));
        }
        return new IQuickFix[0];
    }

    IQuickFix[] getQuickFixes(IFile file, IJavaProject javaProject, String text, BatchArtifactType type, String message) {
        IJavaElement element = this.findJavaElementByQualifiedName(javaProject, text);
        if (element == null) {
            return new IQuickFix[]{new CreateBatchArtifactQuickFix(file, text, type, message)};
        }
        return new IQuickFix[0];
    }
}

