/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.devtools;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.devtools.DevToolsDebuggerServer;

public class DevToolsWebSocket
implements WebSocketListener {
    public static final String WEB_SOCKET_ATTR_NAME = "org.jboss.tools.browsersim.ui.devtools.DevToolsWebSocket";
    private Session session;
    private ServletContext context = DevToolsDebuggerServer.getServletContext();

    public void onWebSocketConnect(Session session) {
        this.session = session;
        if (this.context.getAttribute(WEB_SOCKET_ATTR_NAME) != null) {
            session.close();
            System.out.println(Messages.DevTools_CONNECTION_REFUSED);
        } else {
            this.context.setAttribute(WEB_SOCKET_ATTR_NAME, (Object)this);
            System.out.println(Messages.DevTools_CLIENT_CONNECTED);
        }
    }

    public void onWebSocketClose(int closeCode, String message) {
        DevToolsWebSocket mainSocket = (DevToolsWebSocket)this.context.getAttribute(WEB_SOCKET_ATTR_NAME);
        if (mainSocket == this) {
            this.context.removeAttribute(WEB_SOCKET_ATTR_NAME);
            System.out.println(Messages.DevTools_CLIENT_DISCONNECTED);
        }
    }

    public void sendMessage(String data) throws IOException {
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(data);
    }

    public void onWebSocketText(String data) {
        DevToolsDebuggerServer.sendMessageToBrowser(data);
    }

    public void onWebSocketError(Throwable t) {
        String errorMessage = t.getMessage();
        System.out.println(MessageFormat.format(Messages.DevTools_WEBSOCKET_ERROR, errorMessage));
        BrowserSimLogger.logError(errorMessage, t);
    }

    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }
}

