/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.launch;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.browsersim.ui.BrowserSim;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.CocoaUIEnhancer;
import org.jboss.tools.browsersim.ui.ExceptionNotifier;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.devtools.DevToolsDebuggerServer;
import org.jboss.tools.browsersim.ui.launch.BrowserSimArgs;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;
import org.jboss.tools.browsersim.ui.util.JavaFXUtil;

public class BrowserSimRunner {
    public static final String ABOUT_BLANK = "about:blank";
    private static final String STANDALONE_MOCK_JAR = "javafx-mock.jar";
    private static boolean isJavaFxAvailable;
    private static boolean isWebKitAvailable;
    private static Path tempDir;

    static {
        if ("macosx".equals(PlatformUtil.getOs())) {
            CocoaUIEnhancer.initializeMacOSMenuBar(Messages.BrowserSim_BROWSER_SIM);
        }
        String platform = PlatformUtil.getOs();
        isJavaFxAvailable = false;
        boolean isLinux = "linux".equals(platform);
        if (!isLinux || BrowserSimUtil.isRunningAgainstGTK2()) {
            isJavaFxAvailable = JavaFXUtil.loadJavaFX();
        }
        isWebKitAvailable = BrowserSimUtil.isWebkitAvailable();
    }

    public static void main(String[] args) {
        block32: {
            block34: {
                Display display = null;
                try {
                    String url;
                    String path;
                    if (!isJavaFxAvailable && !isWebKitAvailable) {
                        String errorMessage = "";
                        String os = PlatformUtil.getOs();
                        if ("linux".equals(os)) {
                            errorMessage = MessageFormat.format(BrowserSimUtil.isGTK3() ? Messages.BrowserSim_NO_WEB_ENGINES_LINUX_GTK3 : Messages.BrowserSim_NO_WEB_ENGINES_LINUX, Messages.BrowserSim_BROWSER_SIM);
                        } else if ("win32".equals(os)) {
                            errorMessage = MessageFormat.format(Messages.BrowserSim_NO_WEB_ENGINES_WINDOWS, Messages.BrowserSim_BROWSER_SIM);
                        }
                        throw new SWTError(errorMessage);
                    }
                    BrowserSimArgs browserSimArgs = BrowserSimArgs.parseArgs(args);
                    if (!isJavaFxAvailable && BrowserSimArgs.standalone) {
                        tempDir = Files.createTempDirectory("browsersim", new FileAttribute[0]);
                        JavaFXUtil.loadMock(tempDir.toString(), STANDALONE_MOCK_JAR);
                    }
                    if ((path = browserSimArgs.getPath()) != null) {
                        try {
                            new URI(path);
                            url = path;
                        }
                        catch (URISyntaxException e) {
                            url = ABOUT_BLANK;
                        }
                    } else {
                        url = ABOUT_BLANK;
                    }
                    Shell parent = null;
                    if (!"macosx".equals(PlatformUtil.getOs())) {
                        parent = new Shell(Display.getDefault(), 8);
                        parent.setSize(0, 0);
                        BrowserSimUtil.setShellAttributes(parent);
                        parent.open();
                    }
                    BrowserSim browserSim = new BrowserSim(url, parent);
                    browserSim.open(isJavaFxAvailable, isWebKitAvailable);
                    if (browserSim.getBrowser() instanceof JavaFXBrowser && !"STARTED".equals(DevToolsDebuggerServer.getServerState())) {
                        DevToolsDebuggerServer.startDebugServer(((JavaFXBrowser)browserSim.getBrowser()).getDebugger());
                    }
                    display = Display.getDefault();
                    while (!display.isDisposed() && BrowserSim.getInstances().size() > 0) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
                catch (SWTError e) {
                    ExceptionNotifier.showBrowserSimLoadError(new Shell(Display.getDefault()), e, Messages.BrowserSim_BROWSER_SIM);
                    if (display != null) {
                        display.dispose();
                    }
                    if (BrowserSimArgs.standalone && tempDir != null) {
                        try {
                            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    Files.delete(file);
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                    Files.delete(dir);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        catch (IOException e2) {
                            BrowserSimLogger.logError(e2.getMessage(), e2);
                        }
                    }
                    break block32;
                }
                catch (Throwable t) {
                    block33: {
                        try {
                            BrowserSimLogger.logError(t.getMessage(), t);
                            if (display == null) break block33;
                        }
                        catch (Throwable throwable) {
                            if (display != null) {
                                display.dispose();
                            }
                            if (BrowserSimArgs.standalone && tempDir != null) {
                                try {
                                    Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (IOException e) {
                                    BrowserSimLogger.logError(e.getMessage(), e);
                                }
                            }
                            throw throwable;
                        }
                        display.dispose();
                    }
                    if (BrowserSimArgs.standalone && tempDir != null) {
                        try {
                            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (IOException e) {
                            BrowserSimLogger.logError(e.getMessage(), e);
                        }
                    }
                    break block32;
                }
                if (display == null) break block34;
                display.dispose();
            }
            if (BrowserSimArgs.standalone && tempDir != null) {
                try {
                    Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
                }
                catch (IOException e) {
                    BrowserSimLogger.logError(e.getMessage(), e);
                }
            }
        }
    }
}

