/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.menu;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.model.preferences.CommonPreferences;
import org.jboss.tools.browsersim.ui.util.PreferencesUtil;

public class ScreenshotMenuCreator {
    private static final String EXTENSION = ".png";
    private static ImageData data;

    public static Menu createScreenshotsMenu(Menu parent, final Display display, final Shell shell, final CommonPreferences commonPreferences) {
        Menu screenshotsMenu = new Menu(parent);
        MenuItem saveItem = new MenuItem(screenshotsMenu, 8);
        saveItem.setText(Messages.Screenshots_Save);
        saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        org.eclipse.swt.graphics.Image image = ScreenshotMenuCreator.takeScreenshot(display, shell);
                        String defaultFolder = commonPreferences.getScreenshotsFolder();
                        if (defaultFolder.isEmpty()) {
                            defaultFolder = ScreenshotMenuCreator.saveAs(shell);
                            if (defaultFolder != null) {
                                File selected = new File(defaultFolder);
                                commonPreferences.setScreenshotsFolder(selected.getParentFile().getAbsolutePath());
                                ScreenshotMenuCreator.saveImage(image, selected.getParentFile().getAbsolutePath(), selected.getName());
                                image.dispose();
                            }
                        } else {
                            ScreenshotMenuCreator.saveImage(image, defaultFolder);
                        }
                        image.dispose();
                    }
                });
            }
        });
        MenuItem saveAsItem = new MenuItem(screenshotsMenu, 8);
        saveAsItem.setText(Messages.Screenshots_SaveAs);
        saveAsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String selectedPath = ScreenshotMenuCreator.saveAs(shell);
                if (selectedPath != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            File selected = new File(selectedPath);
                            org.eclipse.swt.graphics.Image image = ScreenshotMenuCreator.takeScreenshot(display, shell);
                            ScreenshotMenuCreator.saveImage(image, selected.getParentFile().getAbsolutePath(), selected.getName());
                            image.dispose();
                        }
                    });
                }
            }
        });
        MenuItem copyItem = new MenuItem(screenshotsMenu, 8);
        copyItem.setText(Messages.Screenshots_CopyToClipboard);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        org.eclipse.swt.graphics.Image image = ScreenshotMenuCreator.takeScreenshot(display, shell);
                        if ("linux".equals(PlatformUtil.getOs())) {
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            BufferedImage awtImage = ScreenshotMenuCreator.convertToAWT(image.getImageData());
                            ImageSelection selection = new ImageSelection(awtImage);
                            clipboard.setContents(selection, null);
                            awtImage.flush();
                        } else {
                            org.eclipse.swt.dnd.Clipboard cl = new org.eclipse.swt.dnd.Clipboard(display);
                            cl.setContents(new Object[]{image.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
                            cl.dispose();
                        }
                        image.dispose();
                    }
                });
            }
        });
        return screenshotsMenu;
    }

    private static org.eclipse.swt.graphics.Image takeScreenshot(Display display, Shell parent) {
        GC gc = new GC((Drawable)parent);
        org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)display, parent.getClientArea());
        gc.copyArea(image, 0, 0);
        GC gcImage = new GC((Drawable)image);
        gcImage.setForeground(display.getSystemColor(1));
        gcImage.setAdvanced(true);
        Region region = parent.getRegion();
        data = image.getImageData();
        if (region != null) {
            int height = image.getBounds().height;
            int width = image.getBounds().width;
            byte[] alphaData = new byte[height * width];
            int currentPosition = 0;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    if (!region.contains(j, i)) {
                        gcImage.drawPoint(j, i);
                        alphaData[currentPosition] = 0;
                    } else {
                        alphaData[currentPosition] = -1;
                    }
                    ++currentPosition;
                    ++j;
                }
                ++i;
            }
            ScreenshotMenuCreator.data.alphaData = alphaData;
        }
        image.dispose();
        gcImage.dispose();
        gc.dispose();
        return new org.eclipse.swt.graphics.Image((Device)display, data);
    }

    private static String saveAs(Shell parent) {
        FileDialog fd = new FileDialog(parent, 8192);
        fd.setText(Messages.Screenshots_SaveAsDialog);
        String[] filterExt = new String[]{"*.png"};
        fd.setFilterExtensions(filterExt);
        fd.setFileName(ScreenshotMenuCreator.getDefaultFilename());
        return fd.open();
    }

    private static void saveImage(org.eclipse.swt.graphics.Image image, String defaultScreenshotFolder) {
        File f = new File(defaultScreenshotFolder);
        f.mkdirs();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(String.valueOf(defaultScreenshotFolder) + PreferencesUtil.SEPARATOR + ScreenshotMenuCreator.getDefaultFilename(), 5);
        image.dispose();
    }

    private static void saveImage(org.eclipse.swt.graphics.Image image, String folder, String fileName) {
        File f = new File(folder);
        f.mkdirs();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(String.valueOf(f.getAbsolutePath()) + PreferencesUtil.SEPARATOR + fileName, 5);
        image.dispose();
    }

    private static String getDefaultFilename() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        return "browsersim_" + df.format(new Date()) + EXTENSION;
    }

    private static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        colorModel = ColorModel.getRGBdefault();
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel = data.getPixel(x, y);
                RGB rgb = palette.getRGB(pixel);
                byte alpha = (byte)data.getAlpha(x, y);
                bufferedImage.setRGB(x, y, alpha << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private static class ImageSelection
    implements Transferable {
        private Image theImage;

        public ImageSelection(Image image) {
            this.theImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.imageFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DataFlavor.imageFlavor)) {
                return this.theImage;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

