/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.skin;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.browser.IBrowserSimBrowserFactory;
import org.jboss.tools.browsersim.ui.ControlHandler;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.browsersim.ui.skin.ResizableSkinSizeAdvisor;
import org.jboss.tools.browsersim.ui.skin.TextSelectionUtil;
import org.jboss.tools.browsersim.ui.util.BrowserSimResourcesUtil;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;

public class NativeSkin
implements BrowserSimSkin {
    private ProgressBar progressBar;
    private Label statusLabel;
    private Text locationText;
    private Shell shell;
    private IBrowser browser;
    private Menu menuBar;
    private ControlHandler controlHandler;
    private ToolItem itemBack;
    private ToolItem itemForward;
    private ToolItem itemStop;
    private ToolItem itemRefresh;
    private ToolItem itemGo;
    private ToolItem itemRotateCounterclockwise;
    private ToolItem itemRotateClockwise;
    private Composite skinComposite;
    private Composite innerBrowserContainer;
    private IBrowserSimBrowserFactory browserFactory;

    @Override
    public void setBrowserFactory(IBrowserSimBrowserFactory browserFactory) {
        this.browserFactory = browserFactory;
    }

    @Override
    public void createControls(Display display, Point location, Shell parentShell, boolean javaFx) {
        this.shell = parentShell == null ? new Shell(display) : new Shell(parentShell, 1264);
        this.shell.setLayout((Layout)new FillLayout(768));
        if (location != null) {
            this.shell.setLocation(location);
        }
        this.menuBar = display.getMenuBar();
        if (this.menuBar == null) {
            this.menuBar = new Menu((Decorations)this.shell, 2);
            this.shell.setMenuBar(this.menuBar);
        }
        this.skinComposite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.skinComposite.setLayout((Layout)gridLayout);
        ToolBar toolbar = this.createControlBar();
        GridData toolbarData = new GridData();
        toolbarData.horizontalSpan = 3;
        toolbarData.verticalIndent = 5;
        toolbarData.horizontalIndent = 5;
        toolbar.setLayoutData((Object)toolbarData);
        Composite addressComposite = new Composite(this.skinComposite, 0);
        GridData adressCompositeGridData = new GridData();
        adressCompositeGridData.horizontalSpan = 3;
        adressCompositeGridData.horizontalAlignment = 4;
        GridLayout adressLayout = new GridLayout();
        adressLayout.numColumns = 2;
        adressLayout.marginHeight = 4;
        adressLayout.marginWidth = 4;
        addressComposite.setLayout((Layout)adressLayout);
        addressComposite.setLayoutData((Object)adressCompositeGridData);
        Label labelAddress = new Label(addressComposite, 0);
        labelAddress.setText(Messages.BrowserSim_ADDRESS);
        this.locationText = new Text(addressComposite, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 0;
        this.locationText.setLayoutData((Object)data);
        this.innerBrowserContainer = new Composite(this.skinComposite, 0);
        this.browser = this.browserFactory.createBrowser(this.innerBrowserContainer, 0, javaFx);
        StackLayout stackLayout = new StackLayout();
        this.innerBrowserContainer.setLayout((Layout)stackLayout);
        stackLayout.topControl = (Control)this.browser;
        GridData browserData = new GridData();
        browserData.horizontalAlignment = 4;
        browserData.verticalAlignment = 4;
        browserData.horizontalSpan = 3;
        browserData.grabExcessHorizontalSpace = true;
        browserData.grabExcessVerticalSpace = true;
        this.innerBrowserContainer.setLayoutData((Object)browserData);
        Composite statusComposite = new Composite(this.skinComposite, 0);
        GridData statusData = new GridData();
        statusData.horizontalSpan = 3;
        statusData.horizontalAlignment = 4;
        GridLayout statusLayout = new GridLayout();
        statusLayout.numColumns = 2;
        statusLayout.marginHeight = 4;
        statusLayout.marginWidth = 4;
        statusComposite.setLayout((Layout)statusLayout);
        statusComposite.setLayoutData((Object)statusData);
        this.statusLabel = new Label(statusComposite, 0);
        data = new GridData(768);
        data.widthHint = 0;
        this.statusLabel.setLayoutData((Object)data);
        this.progressBar = new ProgressBar(statusComposite, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.progressBar.setLayoutData((Object)data);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.locationText.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                NativeSkin.this.controlHandler.goToAddress(NativeSkin.this.locationText.getText());
            }
        });
        this.itemBack.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.goBack();
            }
        });
        this.itemForward.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.goForward();
            }
        });
        this.itemStop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.stop();
            }
        });
        this.itemRefresh.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.refresh();
            }
        });
        this.itemRotateCounterclockwise.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.rotate(true);
            }
        });
        this.itemRotateClockwise.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.rotate(false);
            }
        });
        this.itemGo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NativeSkin.this.controlHandler.goToAddress(NativeSkin.this.locationText.getText());
            }
        });
        TextSelectionUtil.addSelectTextOnFocusListener(this.locationText);
    }

    @Override
    public void setControlHandler(ControlHandler controlHandler) {
        this.controlHandler = controlHandler;
    }

    private ToolBar createControlBar() {
        ToolBar toolbar = new ToolBar(this.skinComposite, 0);
        this.itemBack = new ToolItem(toolbar, 8);
        this.itemForward = new ToolItem(toolbar, 8);
        this.itemStop = new ToolItem(toolbar, 8);
        this.itemRefresh = new ToolItem(toolbar, 8);
        this.itemGo = new ToolItem(toolbar, 8);
        this.itemRotateCounterclockwise = new ToolItem(toolbar, 8);
        this.itemRotateClockwise = new ToolItem(toolbar, 8);
        Display display = this.skinComposite.getDisplay();
        final Image imageBack = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/nav_backward.gif"));
        final Image imageForward = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/nav_forward.gif"));
        final Image imageStop = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/nav_stop.gif"));
        final Image imageRefresh = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/nav_refresh.gif"));
        final Image imageGo = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/nav_go.gif"));
        final Image imageRotateClockwise = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/rotate_clockwise.png"));
        final Image imageRotateCounterclockwise = new Image((Device)display, BrowserSimResourcesUtil.getResourceAsStream("native_skin/rotate_counterclockwise.png"));
        this.itemBack.setImage(imageBack);
        this.itemForward.setImage(imageForward);
        this.itemStop.setImage(imageStop);
        this.itemRefresh.setImage(imageRefresh);
        this.itemGo.setImage(imageGo);
        this.itemRotateClockwise.setImage(imageRotateClockwise);
        this.itemRotateCounterclockwise.setImage(imageRotateCounterclockwise);
        this.skinComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                imageBack.dispose();
                imageForward.dispose();
                imageStop.dispose();
                imageRefresh.dispose();
                imageGo.dispose();
                imageRotateClockwise.dispose();
                imageRotateCounterclockwise.dispose();
            }
        });
        return toolbar;
    }

    @Override
    public void setOrientationAndLocationAndSize(int orientation, Point location, Point browserSize, ResizableSkinSizeAdvisor sizeAdvisor) {
        GridData data = (GridData)this.innerBrowserContainer.getLayoutData();
        if (browserSize.x != -1) {
            data.widthHint = browserSize.x;
        }
        if (browserSize.y != -1) {
            data.heightHint = browserSize.y;
        }
        Point prefferedShellSize = this.shell.computeSize(-1, -1);
        Point shellSize = sizeAdvisor.checkWindowSize(orientation, browserSize, prefferedShellSize);
        this.shell.setSize(shellSize);
        BrowserSimUtil.setShellLocation(this.shell, shellSize, location);
    }

    @Override
    public IBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public Menu getMenuBar() {
        return this.menuBar;
    }

    @Override
    public Point getMinimalScreenSize() {
        return new Point(0, 0);
    }

    @Override
    public void locationChanged(String location, boolean backEnabled, boolean forwardEnabled) {
        this.locationText.setText(location);
        this.itemBack.setEnabled(backEnabled);
        this.itemForward.setEnabled(forwardEnabled);
    }

    @Override
    public void progressChanged(int percents) {
        if (!this.progressBar.isDisposed()) {
            if (percents > 0) {
                this.progressBar.setEnabled(true);
                this.progressBar.setSelection(percents);
            } else {
                this.progressBar.setSelection(0);
                this.progressBar.setEnabled(false);
            }
        }
    }

    @Override
    public void pageTitleChanged(String newTitle) {
    }

    @Override
    public void statusTextChanged(String statusText) {
        this.statusLabel.setText(statusText);
    }

    @Override
    public void setAddressBarVisible(boolean visible) {
    }

    @Override
    public void setContextMenu(Menu contextMenu) {
    }

    @Override
    public boolean automaticallyHideAddressBar() {
        return false;
    }
}

