/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.internal.core.impl.BuiltInBean;
import org.jboss.tools.cdi.internal.core.impl.BuiltInBeanInfo;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.ConversationBuiltInBean;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.impl.AnnotationLiteral;

public class BuiltInBeanFactory {
    public static final Set<String> BUILT_IN = new HashSet<String>();
    static final Map<String, BuiltInBeanInfo> BUILT_IN_INFO = new HashMap<String, BuiltInBeanInfo>();

    static {
        BUILT_IN.add("javax.transaction.UserTransaction");
        BUILT_IN.add("java.security.Principal");
        BUILT_IN.add("javax.validation.ValidatorFactory");
        BUILT_IN.add("javax.validation.Validator");
        BUILT_IN.add("javax.enterprise.inject.spi.BeanManager");
        BUILT_IN.add("javax.enterprise.context.Conversation");
        BUILT_IN.add("javax.enterprise.inject.spi.InjectionPoint");
        BUILT_IN.add("javax.servlet.http.HttpSession");
        BUILT_IN.add("javax.servlet.http.HttpServletRequest");
        BUILT_IN.add("javax.jms.JMSContext");
        BUILT_IN.add("org.jboss.weld.context.DependentContext");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.SingletonContext", "javax.inject.Singleton", null);
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.ApplicationContext", "javax.enterprise.context.ApplicationScoped", null);
        BuiltInBeanFactory.addInfo((String)"org.jboss.weld.context.RequestContext", (String)"javax.enterprise.context.RequestScoped", (String)"org.jboss.weld.context.unbound.Unbound").defaultQualifier = false;
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.bound.BoundRequestContext", "javax.enterprise.context.RequestScoped", "org.jboss.weld.context.bound.Bound");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.http.HttpRequestContext", "javax.enterprise.context.RequestScoped", "org.jboss.weld.context.http.Http");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.ejb.EjbRequestContext", "javax.enterprise.context.RequestScoped", "org.jboss.weld.context.ejb.Ejb");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.bound.BoundSessionContext", "javax.enterprise.context.SessionScoped", "org.jboss.weld.context.bound.Bound");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.http.HttpSessionContext", "javax.enterprise.context.SessionScoped", "org.jboss.weld.context.http.Http");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.bound.BoundConversationContext", "javax.enterprise.context.ConversationScoped", "org.jboss.weld.context.bound.Bound");
        BuiltInBeanFactory.addInfo("org.jboss.weld.context.http.HttpConversationContext", "javax.enterprise.context.ConversationScoped", "org.jboss.weld.context.http.Http");
    }

    static BuiltInBeanInfo addInfo(String type, String scopeName, String qualifierName) {
        BUILT_IN.add(type);
        BuiltInBeanInfo info = new BuiltInBeanInfo(scopeName, qualifierName);
        BUILT_IN_INFO.put(type, info);
        return info;
    }

    public static boolean isBuiltIn(IType type) {
        return type != null && BUILT_IN.contains(type.getFullyQualifiedName());
    }

    public static ClassBean newClassBean(CDIProject project, TypeDefinition def) {
        ClassBean result = null;
        String typeName = def.getType().getFullyQualifiedName();
        if (typeName.equals("javax.enterprise.context.Conversation")) {
            result = new ConversationBuiltInBean();
        } else {
            BuiltInBean b = new BuiltInBean();
            BuiltInBeanInfo info = BUILT_IN_INFO.get(typeName);
            if (info != null) {
                if (info.scopeName != null) {
                    b.scopeName = info.scopeName;
                }
                if (info.qualifierName != null) {
                    BuiltInBeanFactory.addAnnotation(project, def, info.qualifierName);
                    if (info.defaultQualifier) {
                        BuiltInBeanFactory.addAnnotation(project, def, "javax.enterprise.inject.Default");
                    }
                }
            }
            result = b;
        }
        result.setParent(project);
        result.setDefinition(def);
        return result;
    }

    private static void addAnnotation(CDIProject project, TypeDefinition def, String typeName) {
        IType t;
        if (def.getAnnotation(typeName) == null && (t = project.getNature().getType(typeName)) != null) {
            AnnotationLiteral l = new AnnotationLiteral(project.getResource(), 0, 0, null, 0, t);
            def.addAnnotation((IJavaAnnotation)l, project.getNature().getDefinitions());
        }
    }
}

