/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IInitializerMethod;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IObserverMethod;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AbstractBeanElement;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanField;
import org.jboss.tools.cdi.internal.core.impl.BeanMethod;
import org.jboss.tools.cdi.internal.core.impl.DisposerMethod;
import org.jboss.tools.cdi.internal.core.impl.InitializerMethod;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointField;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBindingDeclaration;
import org.jboss.tools.cdi.internal.core.impl.ObserverAsyncMethod;
import org.jboss.tools.cdi.internal.core.impl.ObserverMethod;
import org.jboss.tools.cdi.internal.core.impl.ProducerField;
import org.jboss.tools.cdi.internal.core.impl.ProducerMethod;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.BeanUtil;

public class ClassBean
extends AbstractBeanElement
implements IClassBean {
    protected ClassBean superClassBean = null;
    protected Map<String, ClassBean> specializingClassBeans = new HashMap<String, ClassBean>();
    protected List<BeanField> fields = new ArrayList<BeanField>();
    protected List<BeanMethod> methods = new ArrayList<BeanMethod>();
    protected IScope scope = null;

    @Override
    public boolean exists() {
        IType t = this.getBeanClass();
        return t != null && t.exists();
    }

    public void setDefinition(TypeDefinition definition) {
        this.setSourcePath(definition.getType().getPath());
        super.setDefinition(definition);
        List<MethodDefinition> ms = definition.getMethods();
        for (MethodDefinition m : ms) {
            if (!m.getMethod().exists()) continue;
            BeanMethod bm = null;
            bm = m.getProducesAnnotation() != null ? this.newProducerMethod(m) : (m.getInjectAnnotation() != null ? new InitializerMethod() : (m.isObserver() ? new ObserverMethod() : (m.isObserverAsync() ? new ObserverAsyncMethod() : (m.isDisposer() ? new DisposerMethod() : new BeanMethod()))));
            bm.setClassBean(this);
            ((BeanMethod)bm).setDefinition(m);
            this.methods.add(bm);
        }
        List<FieldDefinition> fs = definition.getFields();
        for (FieldDefinition f : fs) {
            if (!f.getField().exists()) continue;
            BeanField bf = null;
            bf = f.getProducesAnnotation() != null ? this.newProducerField(f) : (f.getInjectAnnotation() != null ? new InjectionPointField() : new BeanField());
            bf.setClassBean(this);
            bf.setDefinition(f);
            this.fields.add(bf);
        }
    }

    protected ProducerMethod newProducerMethod(MethodDefinition m) {
        return new ProducerMethod();
    }

    protected ProducerField newProducerField(FieldDefinition f) {
        return new ProducerField();
    }

    @Override
    public TypeDefinition getDefinition() {
        return (TypeDefinition)this.definition;
    }

    @Override
    public ICDIProject getDeclaringProject() {
        ICDIProject result = this.definition.getDeclaringProject().getDelegate();
        if (result == null) {
            result = this.getCDIProject();
        }
        return result;
    }

    @Override
    public Collection<IBeanMethod> getBeanConstructors() {
        ArrayList<IBeanMethod> result = new ArrayList<IBeanMethod>();
        BeanMethod defaultConstructor = null;
        for (BeanMethod m : this.methods) {
            if (!m.getDefinition().isConstructor()) continue;
            if (m.getAnnotation("javax.inject.Inject") == null && m.getMethod().getNumberOfParameters() == 0) {
                defaultConstructor = m;
                continue;
            }
            result.add(m);
        }
        if (result.isEmpty() && defaultConstructor != null) {
            result.add(defaultConstructor);
        }
        return result;
    }

    public void setSuperClassBean(IClassBean bean) {
        if (!(bean instanceof ClassBean) || bean == this) {
            return;
        }
        if (bean.getSuperClassBean() != null) {
            HashSet<ClassBean> beans = new HashSet<ClassBean>();
            beans.add(this);
            IClassBean b = bean;
            while (b != null) {
                if (beans.contains(b)) {
                    bean = null;
                    break;
                }
                b = b.getSuperClassBean();
            }
        }
        this.superClassBean = (ClassBean)bean;
        if (this.superClassBean != null && this.isSpecializing()) {
            this.superClassBean.addSpecializingClassBean(this);
        }
        if (this.superClassBean != null) {
            Map<String, ProducerMethod> thisProducers = this.getProducerMethodsForSignatures();
            Map<String, ProducerMethod> superProducers = this.superClassBean.getProducerMethodsForSignatures();
            for (String s : thisProducers.keySet()) {
                ProducerMethod thisProducer = thisProducers.get(s);
                ProducerMethod superProducer = superProducers.get(s);
                if (thisProducer == null || superProducer == null || thisProducer.getSpecializesAnnotationDeclaration() == null) continue;
                thisProducer.setSpecializedBean(superProducer);
            }
        }
    }

    Map<String, ProducerMethod> getProducerMethodsForSignatures() {
        HashMap<String, ProducerMethod> result = new HashMap<String, ProducerMethod>();
        for (BeanMethod b : this.methods) {
            if (!(b instanceof ProducerMethod)) continue;
            String s = b.getMethod().getElementName();
            try {
                s = String.valueOf(s) + ":" + b.getMethod().getSignature();
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
            result.put(s, (ProducerMethod)b);
        }
        return result;
    }

    synchronized void addSpecializingClassBean(ClassBean bean) {
        if (this.specializingClassBeans == null) {
            this.specializingClassBeans = new Hashtable<String, ClassBean>();
        }
        this.specializingClassBeans.put(bean.getBeanClass().getFullyQualifiedName(), bean);
    }

    @Override
    public ClassBean getSuperClassBean() {
        return this.superClassBean;
    }

    @Override
    public Collection<IBeanMethod> getDisposers() {
        ArrayList<IBeanMethod> result = new ArrayList<IBeanMethod>();
        for (BeanMethod m : this.methods) {
            if (!m.isDisposer()) continue;
            result.add(m);
        }
        return result;
    }

    public static Collection<IInterceptorBindingDeclaration> getInterceptorBindingDeclarations(AbstractMemberDefinition definition) {
        ArrayList<IInterceptorBindingDeclaration> result = new ArrayList<IInterceptorBindingDeclaration>();
        List<IAnnotationDeclaration> as = definition.getAnnotations();
        for (IAnnotationDeclaration a : as) {
            if (!(a instanceof InterceptorBindingDeclaration)) continue;
            result.add((InterceptorBindingDeclaration)a);
        }
        return result;
    }

    @Override
    public Collection<IInterceptorBinding> getInterceptorBindings() {
        return CDIUtil.getAllInterceptorBindings(this);
    }

    @Override
    public Collection<IObserverMethod> getObserverMethods() {
        ArrayList<IObserverMethod> result = new ArrayList<IObserverMethod>();
        for (BeanMethod m : this.methods) {
            if (!m.isObserver() || !(m instanceof IObserverMethod)) continue;
            result.add((IObserverMethod)((Object)m));
        }
        return result;
    }

    @Override
    public Collection<IProducer> getProducers() {
        ArrayList<IProducer> result = new ArrayList<IProducer>();
        for (BeanMethod m : this.methods) {
            if (!(m instanceof IProducer)) continue;
            result.add((IProducer)((Object)m));
        }
        for (BeanField f : this.fields) {
            if (!(f instanceof IProducer)) continue;
            result.add((IProducer)((Object)f));
        }
        return result;
    }

    @Override
    public Collection<ITypeDeclaration> getAllTypeDeclarations() {
        Collection<IParametedType> ps = this.getDefinition().getInheritedTypes();
        HashSet<ITypeDeclaration> result = new HashSet<ITypeDeclaration>();
        for (IParametedType iParametedType : ps) {
            if (!(iParametedType instanceof TypeDeclaration)) continue;
            result.add((ITypeDeclaration)((TypeDeclaration)iParametedType));
        }
        ParametedType parametedType = this.getDefinition().getParametedType();
        if (parametedType != null && parametedType instanceof TypeDeclaration) {
            result.add((ITypeDeclaration)((TypeDeclaration)parametedType));
        }
        return result;
    }

    @Override
    public IAnnotationDeclaration getAlternativeDeclaration() {
        return this.getDefinition().getAlternativeAnnotation();
    }

    @Override
    public IType getBeanClass() {
        return ((TypeDefinition)this.definition).getType();
    }

    @Override
    public Collection<IInitializerMethod> getInitializers() {
        ArrayList<IInitializerMethod> result = new ArrayList<IInitializerMethod>();
        for (BeanMethod m : this.methods) {
            if (!(m instanceof IInitializerMethod)) continue;
            result.add((IInitializerMethod)((Object)m));
        }
        return result;
    }

    @Override
    public Collection<IInjectionPoint> getInjectionPoints() {
        return this.getInjectionPoints(true);
    }

    @Override
    public Collection<IInjectionPoint> getInjectionPoints(boolean all) {
        ArrayList<IInjectionPoint> result = new ArrayList<IInjectionPoint>();
        for (BeanField f : this.fields) {
            if (!(f instanceof IInjectionPoint)) continue;
            result.add((IInjectionPoint)((Object)f));
        }
        for (BeanMethod m : this.methods) {
            if (!all && m instanceof IBean) continue;
            List<IParameter> ps = m.getParameters();
            for (IParameter p : ps) {
                if (!(p instanceof IInjectionPoint)) continue;
                result.add((IInjectionPoint)((Object)p));
            }
        }
        return result;
    }

    @Override
    public Collection<IParametedType> getLegalTypes() {
        HashSet<IParametedType> result = new HashSet<IParametedType>();
        AnnotationDeclaration d = this.getDefinition().getTypedAnnotation();
        Collection<IParametedType> all = this.getAllTypes();
        if (d != null) {
            result.addAll(this.getRestrictedTypeDeclarations(all));
            ParametedType object = this.getObjectType((IMember)this.getBeanClass());
            if (object != null) {
                result.add((IParametedType)object);
            }
            return result;
        }
        return all;
    }

    @Override
    public Collection<IParametedType> getAllTypes() {
        return this.getDefinition().getAllTypes();
    }

    @Override
    public Collection<ITypeDeclaration> getRestrictedTypeDeclaratios() {
        return this.getRestrictedTypeDeclarations(this.getAllTypes());
    }

    @Override
    public String getName() {
        String name;
        ClassBean specialized = this.getSpecializedBean();
        if (specialized != null && (name = specialized.getName()) != null) {
            return name;
        }
        AnnotationDeclaration named = this.findNamedAnnotation();
        if (named == null) {
            return null;
        }
        String name2 = BeanUtil.getDefaultBeanName((IType)((AbstractTypeDefinition)this.definition).getType());
        Object value = named.getMemberValue(null, true);
        if (value != null && value.toString().trim().length() > 0) {
            return value.toString().trim();
        }
        return name2;
    }

    @Override
    public ITextSourceReference getNameLocation(boolean stereotypeLocation) {
        return stereotypeLocation ? CDIUtil.getNamedDeclaration(this) : this.findNamedAnnotation();
    }

    @Override
    public ClassBean getSpecializedBean() {
        if (this.getDefinition().getSpecializesAnnotation() == null) {
            return null;
        }
        return this.superClassBean;
    }

    public synchronized Collection<ClassBean> getSpecializingBeans() {
        return this.specializingClassBeans == null ? Collections.emptySet() : this.specializingClassBeans.values();
    }

    @Override
    public IAnnotationDeclaration getSpecializesAnnotationDeclaration() {
        return this.getDefinition().getSpecializesAnnotation();
    }

    @Override
    public boolean isDependent() {
        IScope scope = this.getScope();
        return scope != null && "javax.enterprise.context.Dependent".equals(scope.getSourceType().getFullyQualifiedName());
    }

    synchronized boolean hasEnabledSpecializingClassBean() {
        if (this.specializingClassBeans != null) {
            for (ClassBean sb : this.specializingClassBeans.values()) {
                if (!sb.hasEnabledSpecializingClassBean() && !sb.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        if (this.hasEnabledSpecializingClassBean()) {
            return false;
        }
        if (this.isAlternative()) {
            if (this.getAnnotation("javax.annotation.Priority") != null) {
                return true;
            }
            if (this.getCDIProject().isClassAlternativeActivated(this.getDefinition().getQualifiedName())) {
                return true;
            }
            for (IStereotypeDeclaration d : this.getStereotypeDeclarations(true)) {
                IStereotype s = d.getStereotype();
                if (s == null || !s.isAlternative() || this.getCDIProject().getAlternatives(s.getSourceType().getFullyQualifiedName()).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSpecializing() {
        return this.getDefinition().getSpecializesAnnotation() != null;
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.computeScope();
        }
        return this.scope;
    }

    protected void computeScope() {
        IScope sc;
        IStereotype s;
        Collection<IScopeDeclaration> scopes = this.getScopeDeclarations();
        if (!scopes.isEmpty()) {
            this.scope = scopes.iterator().next().getScope();
            return;
        }
        ClassBean scb = this.getSuperClassBean();
        while (scb != null) {
            scopes = scb.getScopeDeclarations();
            if (!scopes.isEmpty()) {
                this.scope = scopes.iterator().next().getScope();
                if (this.scope.getInheritedDeclaration() == null) {
                    this.scope = this.getCDIProject().getScope("javax.enterprise.context.Dependent");
                    return;
                }
                return;
            }
            scb = scb.getSuperClassBean();
        }
        HashSet<IScope> defaults = new HashSet<IScope>();
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            s = d.getStereotype();
            sc = s.getScope();
            if (sc == null) continue;
            defaults.add(sc);
        }
        scb = this.getSuperClassBean();
        while (scb != null) {
            for (IStereotypeDeclaration d : scb.getStereotypeDeclarations()) {
                s = d.getStereotype();
                if (s.getInheritedDeclaration() == null || (sc = s.getScope()) == null) continue;
                defaults.add(sc);
            }
            scb = scb.getSuperClassBean();
        }
        this.scope = defaults.size() == 1 ? (IScope)defaults.iterator().next() : (defaults.size() > 1 ? this.getCDIProject().getScope("javax.enterprise.context.Dependent") : this.getCDIProject().getScope("javax.enterprise.context.Dependent"));
    }

    @Override
    protected Collection<IQualifierDeclaration> getInheritedQualifierDeclarations() {
        if (this.superClassBean == null) {
            return Collections.emptySet();
        }
        ArrayList<IQualifierDeclaration> result = new ArrayList<IQualifierDeclaration>();
        for (IQualifierDeclaration d : this.superClassBean.getQualifierDeclarations(true)) {
            if (d.getQualifier() != null && d.getQualifier().getInheritedDeclaration() != null) {
                result.add(d);
                continue;
            }
            if (!this.isSpecializing()) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    protected Collection<IInterceptorBindingDeclaration> getInheritedInterceptorBindingDeclarations() {
        if (this.superClassBean == null) {
            return Collections.emptyList();
        }
        HashSet<IInterceptorBindingDeclaration> result = new HashSet<IInterceptorBindingDeclaration>();
        for (IInterceptorBindingDeclaration d : this.superClassBean.getInterceptorBindingDeclarations(true)) {
            if (d.getInterceptorBinding() != null && d.getInterceptorBinding().getInheritedDeclaration() != null) {
                result.add(d);
                continue;
            }
            if (!this.isSpecializing()) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public Set<IStereotypeDeclaration> getInheritedStereotypDeclarations() {
        if (this.superClassBean == null) {
            return Collections.emptySet();
        }
        HashSet<IStereotypeDeclaration> result = new HashSet<IStereotypeDeclaration>();
        for (IStereotypeDeclaration d : this.superClassBean.getStereotypeDeclarations(true)) {
            if (d.getStereotype() != null && d.getStereotype().getInheritedDeclaration() != null) {
                result.add(d);
                continue;
            }
            if (!this.isSpecializing()) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isSelectedAlternative() {
        if (this.getDefinition().getAlternativeAnnotation() != null) {
            if (this.getCDIProject().isTypeAlternative(this.getBeanClass().getFullyQualifiedName())) {
                return true;
            }
            if (this.getAnnotation("javax.annotation.Priority") != null) {
                return true;
            }
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations(true)) {
            IStereotype s = d.getStereotype();
            if (s == null || !s.isAlternative() || !this.getCDIProject().isStereotypeAlternative(s.getSourceType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IBeanMethod> getAllMethods() {
        return new ArrayList<IBeanMethod>(this.methods);
    }

    @Override
    public String getElementName() {
        String result = this.getBeanClass().getElementName();
        if (result.length() == 0) {
            result = this.getBeanClass().getFullyQualifiedName();
        }
        return result;
    }

    public ParametedType getSuperType() {
        return this.getDefinition().getSuperType();
    }

    public IMember getSourceMember() {
        return this.getBeanClass();
    }

    public IJavaElement getSourceElement() {
        return this.getSourceMember();
    }

    public synchronized void cleanCache() {
        this.specializingClassBeans = null;
        this.scope = null;
        this.getDefinition().resetParametedType();
        for (BeanMethod m : this.methods) {
            m.setMethod(m.getMethod());
        }
        for (BeanField f : this.fields) {
            f.setField(f.getField());
        }
    }

    @Override
    public Integer getPriority() {
        IAnnotationDeclaration d = this.getAnnotation("javax.annotation.Priority");
        if (d instanceof AnnotationDeclaration) {
            Object o = ((AnnotationDeclaration)d).getMemberConstantValue(null);
            if (o == null) {
                o = d.getMemberValue(null);
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
        }
        return null;
    }
}

