/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanMember;
import org.jboss.tools.cdi.internal.core.impl.BeanMethod;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;

public class Parameter
extends BeanMember
implements IParameter {
    BeanMethod beanMethod;

    @Override
    public ParameterDefinition getDefinition() {
        return (ParameterDefinition)this.definition;
    }

    public void setBeanMethod(BeanMethod beanMethod) {
        this.beanMethod = beanMethod;
        this.setParent(beanMethod);
    }

    public void setDefinition(ParameterDefinition definition) {
        super.setDefinition(definition);
        this.definition = definition;
    }

    public void setLocalVariable(ILocalVariable v) {
        this.setMember((IJavaElement)v);
    }

    @Override
    public String getName() {
        return this.getDefinition().getName();
    }

    @Override
    public IParametedType getMemberType() {
        return this.getDefinition().getType();
    }

    @Override
    public IParametedType getType() {
        if (this.getDefinition().getOverridenType() != null) {
            return this.getDefinition().getOverridenType();
        }
        return this.getDefinition().getType();
    }

    @Override
    public IClassBean getClassBean() {
        return this.beanMethod.getClassBean();
    }

    public IMember getSourceMember() {
        return this.getDefinition().getMethodDefinition().getMethod();
    }

    @Override
    public IJavaElement getSourceElement() {
        return this.getDefinition().getVariable();
    }

    @Override
    protected ISourceReference getSourceReference() {
        return this.getDefinition().getVariable();
    }

    @Override
    public IBeanMethod getBeanMethod() {
        return this.beanMethod;
    }

    @Override
    public Collection<IQualifier> getQualifiers() {
        ArrayList<IQualifier> result = new ArrayList<IQualifier>();
        for (IAnnotationDeclaration s : this.getAnnotations()) {
            IQualifier q;
            if (!(s instanceof IQualifierDeclaration) || (q = ((IQualifierDeclaration)s).getQualifier()) == null) continue;
            result.add(q);
        }
        return result;
    }

    @Override
    public Collection<IQualifierDeclaration> getQualifierDeclarations() {
        ArrayList<IQualifierDeclaration> result = new ArrayList<IQualifierDeclaration>();
        List<IAnnotationDeclaration> ds = this.definition.getAnnotations();
        for (IAnnotationDeclaration d : ds) {
            if (!(d instanceof IQualifierDeclaration)) continue;
            result.add((IQualifierDeclaration)d);
        }
        return result;
    }

    @Override
    public String getElementName() {
        return this.getName();
    }

    @Override
    public boolean isDeclaredFor(IJavaElement element) {
        if (this.getDefinition().getVariable() == element) {
            return true;
        }
        if (element instanceof ILocalVariable) {
            ILocalVariable vThat = (ILocalVariable)element;
            return this.getName().equals(vThat.getElementName()) && this.getBeanMethod().isDeclaredFor((IJavaElement)vThat.getDeclaringMember());
        }
        return false;
    }
}

