/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikePartialbeanDefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;

public class DeltaspikePartialbeanBindingConfiguration {
    String partialbeanBindingTypeName;
    AnnotationDefinition partialbeanBindingType;
    Map<String, TypeDefinition> partialBeans = new HashMap<String, TypeDefinition>();
    Map<String, TypeDefinition> invocationHandlers = new HashMap<String, TypeDefinition>();
    Map<String, TypeDefinition> invalidPartialBeans = new HashMap<String, TypeDefinition>();
    Set<IPath> involvedResources = new HashSet<IPath>();

    public DeltaspikePartialbeanBindingConfiguration(String partialbeanBindingTypeName) {
        this.partialbeanBindingTypeName = partialbeanBindingTypeName;
    }

    public void setPartialbeanBindingTypeDefinition(AnnotationDefinition partialbeanBindingType, DeltaspikePartialbeanDefinitionContext context) {
        this.partialbeanBindingType = partialbeanBindingType;
    }

    public void clear(IPath path) {
        this.involvedResources.remove(path);
    }

    public void clear(String typeName) {
        TypeDefinition t = this.partialBeans.remove(typeName);
        if (t != null) {
            t.setBeanConstructor(false);
        }
        this.invocationHandlers.remove(typeName);
        this.invalidPartialBeans.remove(typeName);
    }

    public String getPartialbeanBindingTypeName() {
        return this.partialbeanBindingTypeName;
    }

    public AnnotationDefinition getPartialbeanBindingTypeDefinition() {
        return this.partialbeanBindingType;
    }

    public Set<IPath> getInvolvedTypes() {
        return this.involvedResources;
    }

    public void addPartialBean(TypeDefinition partialBean) {
        this.partialBeans.put(partialBean.getQualifiedName(), partialBean);
    }

    public void addInvocationHandler(TypeDefinition handler) {
        this.invocationHandlers.put(handler.getQualifiedName(), handler);
    }

    public void addInvalidPartialBean(TypeDefinition partialBean) {
        this.invalidPartialBeans.put(partialBean.getQualifiedName(), partialBean);
    }

    public Map<String, TypeDefinition> getPartialBeans() {
        return this.partialBeans;
    }

    public Map<String, TypeDefinition> getInvocationHandlers() {
        return this.invocationHandlers;
    }

    public Map<String, TypeDefinition> getInvalidPartialBeans() {
        return this.invalidPartialBeans;
    }
}

