/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeAuthorityMethod;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSecurityDefinitionContext;
import org.jboss.tools.cdi.deltaspike.core.SecurityBindingDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;

public class DeltaspikeSecurityBindingConfiguration {
    String securityBindingTypeName;
    AnnotationDefinition securityBindingType;
    Map<AbstractMemberDefinition, SecurityBindingDeclaration> boundMembers = new HashMap<AbstractMemberDefinition, SecurityBindingDeclaration>();
    Set<DeltaspikeAuthorityMethod> authorizerMembers = new HashSet<DeltaspikeAuthorityMethod>();
    Set<IPath> involvedResources = new HashSet<IPath>();

    public DeltaspikeSecurityBindingConfiguration(String securityBindingTypeName) {
        this.securityBindingTypeName = securityBindingTypeName;
    }

    public void setSecurityBundingTypeDefinition(AnnotationDefinition securityBindingType, DeltaspikeSecurityDefinitionContext context) {
        this.securityBindingType = securityBindingType;
    }

    public void clear(IPath path) {
        this.involvedResources.remove(path);
    }

    public void clear(String typeName) {
        Iterator<AbstractMemberDefinition> it = this.boundMembers.keySet().iterator();
        while (it.hasNext()) {
            if (!typeName.equals(it.next().getTypeDefinition().getQualifiedName())) continue;
            it.remove();
        }
        Iterator<DeltaspikeAuthorityMethod> it2 = this.authorizerMembers.iterator();
        while (it2.hasNext()) {
            if (!typeName.equals(it2.next().getDeclaringTypeName())) continue;
            it2.remove();
        }
    }

    public Map<AbstractMemberDefinition, SecurityBindingDeclaration> getBoundMembers() {
        return this.boundMembers;
    }

    public Set<DeltaspikeAuthorityMethod> getAuthorizerMembers() {
        return this.authorizerMembers;
    }

    public String getSecurityBindingTypeName() {
        return this.securityBindingTypeName;
    }

    public AnnotationDefinition getSecurityBindingTypeDefinition() {
        return this.securityBindingType;
    }

    public Set<IPath> getInvolvedTypes() {
        return this.involvedResources;
    }
}

