/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IProducerField;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.core.util.BeanPresentationUtil;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.IInformationItem;
import org.jboss.tools.cdi.text.ext.hyperlink.ITestableCDIHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class InjectedPointHyperlink
extends AbstractHyperlink
implements ITestableCDIHyperlink,
IInformationItem {
    protected IBean bean;
    boolean first = false;

    public InjectedPointHyperlink(IRegion region, IBean bean, IDocument document) {
        this.bean = bean;
        this.setRegion(region);
        this.setDocument(document);
    }

    public InjectedPointHyperlink(IRegion region, IBean bean, IDocument document, boolean first) {
        this(region, bean, document);
        this.first = first;
    }

    public void doHyperlink(IRegion region) {
        IEditorPart part = null;
        if (this.bean != null && this.bean.getBeanClass() != null) {
            try {
                part = JavaUI.openInEditor((IJavaElement)this.bean.getBeanClass());
            }
            catch (JavaModelException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            catch (PartInitException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            IJavaElement element = this.getJavaElement();
            if (part != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)element);
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        String text = "";
        if (this.bean != null) {
            if (this.first) {
                text = String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_INJECT_BEAN) + " ";
            } else {
                text = String.valueOf(CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_OPEN_BEAN) + " ";
                String kind = BeanPresentationUtil.getBeanKind((IBean)this.bean);
                if (kind != null) {
                    if (this.bean.isSelectedAlternative()) {
                        text = String.valueOf(text) + "*";
                    }
                    text = String.valueOf(text) + kind + " ";
                }
            }
            text = String.valueOf(text) + this.bean.getElementName();
        }
        return text;
    }

    private IJavaElement getJavaElement() {
        if (this.bean instanceof IProducerField) {
            return ((IProducerField)this.bean).getField();
        }
        if (this.bean instanceof IProducerMethod) {
            return ((IProducerMethod)this.bean).getMethod();
        }
        return this.bean.getBeanClass();
    }

    @Override
    public ICDIElement getCDIElement() {
        return this.bean;
    }

    public Set<? extends ICDIElement> getCDIElements() {
        return null;
    }
}

