/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class AddSerializableInterfaceMarkerResolution
extends BaseMarkerResolution {
    public static final String SERIALIZABLE = "java.io.Serializable";
    private IType type;

    public AddSerializableInterfaceMarkerResolution(IType type) {
        super(type.getCompilationUnit());
        this.label = MessageFormat.format(CDIUIMessages.ADD_SERIALIZABLE_INTERFACE_MARKER_RESOLUTION_TITLE, type.getElementName());
        this.type = type;
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            CDIMarkerResolutionUtils.addInterfaceToClass((ICompilationUnit)compilationUnit, (IType)this.type, (String)SERIALIZABLE, (MultiTextEdit)edit);
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_ADD);
    }
}

