/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class DeleteAnnotationMarkerResolution
extends BaseMarkerResolution {
    private IJavaElement element;
    private String qualifiedName;

    public DeleteAnnotationMarkerResolution(IJavaElement element, String qualifiedName) {
        String type;
        String shortName;
        block12: {
            super(CDIMarkerResolutionUtils.getJavaMember((IJavaElement)element).getCompilationUnit());
            this.element = element;
            this.qualifiedName = qualifiedName;
            shortName = CDIMarkerResolutionUtils.getShortName((String)qualifiedName);
            type = "";
            if (element instanceof IType) {
                try {
                    if (((IType)element).isAnnotation()) {
                        type = CDIUIMessages.CDI_QUICK_FIXES_ANNOTATION;
                        break block12;
                    }
                    if (((IType)element).isInterface()) {
                        type = CDIUIMessages.CDI_QUICK_FIXES_INTERFACE;
                        break block12;
                    }
                    if (((IType)element).isClass()) {
                        type = CDIUIMessages.CDI_QUICK_FIXES_CLASS;
                        break block12;
                    }
                    type = CDIUIMessages.CDI_QUICK_FIXES_TYPE;
                }
                catch (JavaModelException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
            } else if (element instanceof IMethod) {
                type = CDIUIMessages.CDI_QUICK_FIXES_METHOD;
            } else if (element instanceof IField) {
                type = CDIUIMessages.CDI_QUICK_FIXES_FIELD;
            } else if (element instanceof ILocalVariable && ((ILocalVariable)element).isParameter()) {
                type = NLS.bind((String)CDIUIMessages.CDI_QUICK_FIXES_PARAMETER, (Object)element.getParent().getElementName());
            }
        }
        this.label = NLS.bind((String)CDIUIMessages.DELETE_ANNOTATION_MARKER_RESOLUTION_TITLE, (Object[])new String[]{shortName, element.getElementName(), type});
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            CDIMarkerResolutionUtils.deleteAnnotation((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (IJavaElement)this.element, (MultiTextEdit)edit);
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_REMOVE);
    }
}

