/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.BeansXMLAccess;
import org.jboss.tools.cdi.ui.wizard.InterceptorBindingSelectionProvider;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.common.java.generation.JavaBeanGenerator;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ListFieldEditor;

public class NewInterceptorWizardPage
extends NewClassWizardPage {
    protected InterceptorBindingSelectionProvider interceptorBindingsProvider = new InterceptorBindingSelectionProvider();
    protected ListFieldEditor interceptorBindings = null;
    IFieldEditor methodName = null;
    protected StatusInfo methodNameStatus = new StatusInfo();
    protected StatusInfo interceptorBindingsStatus = new StatusInfo();
    protected boolean mayBeRegisteredInBeansXML = true;
    protected BeansXMLAccess registerInBeansXML = new BeansXMLAccess((NewTypeWizardPage)this, "Interceptors", "CDIClass", "class");

    public void setMayBeRegisteredInBeansXML(boolean b) {
        this.mayBeRegisteredInBeansXML = b;
    }

    public NewInterceptorWizardPage() {
        this.setTitle(CDIUIMessages.NEW_INTERCEPTOR_WIZARD_PAGE_NAME);
        this.setDescription(CDIUIMessages.NEW_INTERCEPTOR_WIZARD_DESCRIPTION);
        this.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIClassWizBan.png"));
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
    }

    public void addInterceptorBinding(ICDIAnnotation a) {
        List list;
        Object o = this.interceptorBindings.getValue();
        List list2 = list = o instanceof List ? (List)o : new ArrayList();
        if (list.contains(a)) {
            return;
        }
        list.add(a);
        this.interceptorBindings.setValue(new ArrayList(list));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.onInterceptorBindingChange();
        this.doStatusUpdate();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        this.addAnnotations(imports, sb, lineDelimiter);
        buf.replace(range.getOffset(), 0, sb.toString());
        this.createAroundInvokeMethod(newType, imports, monitor, lineDelimiter);
    }

    void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addInterceptorBindingAnnotations(imports, sb, lineDelimiter);
        this.addInterceptorAnnotation(imports, sb, lineDelimiter);
    }

    protected void addInterceptorAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        NewCDIAnnotationWizardPage.addAnnotation("javax.interceptor.Interceptor", imports, sb, lineDelimiter);
    }

    protected void addInterceptorBindingAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.interceptorBindings != null) {
            List list = (List)this.interceptorBindings.getValue();
            for (Object o : list) {
                if (!(o instanceof ICDIAnnotation)) continue;
                ICDIAnnotation a = (ICDIAnnotation)o;
                String typeName = a.getSourceType().getFullyQualifiedName();
                NewCDIAnnotationWizardPage.addAnnotation(typeName, imports, sb, lineDelimiter);
            }
        }
    }

    protected void createCustomFields(Composite composite) {
        this.createInterceptorBindingField(composite);
        this.createMethodNameField(composite);
        this.createRegisterInBeansXML(composite);
    }

    protected void createInterceptorBindingField(Composite composite) {
        this.interceptorBindings = new ListFieldEditor("interceptorBindings", CDIUIMessages.FIELD_EDITOR_INTERCEPTOR_BINDINGS_LABEL, new ArrayList());
        this.interceptorBindings.setProvider((ListFieldEditor.ListFieldEditorProvider)this.interceptorBindingsProvider);
        this.interceptorBindingsProvider.setEditorField((IFieldEditor)this.interceptorBindings);
        this.interceptorBindings.doFillIntoGrid((Object)composite);
        this.setInterceptorBindings(this.getPackageFragmentRoot());
        this.interceptorBindings.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewInterceptorWizardPage.this.onInterceptorBindingChange();
                NewInterceptorWizardPage.this.doStatusUpdate();
            }
        });
    }

    void onInterceptorBindingChange() {
        this.interceptorBindingsStatus = new StatusInfo();
        if (((List)this.interceptorBindings.getValue()).isEmpty()) {
            this.interceptorBindingsStatus.setWarning(CDIUIMessages.MESSAGE_INTERCEPTOR_BINDINGS_EMPTY);
        }
    }

    protected void createMethodNameField(Composite composite) {
        String label = "Around Invoke Method Name:";
        this.methodName = IFieldEditorFactory.INSTANCE.createTextEditor("methodName", label, "aroundInvoke");
        ((CompositeEditor)this.methodName).addFieldEditors(new IFieldEditor[]{new LabelFieldEditor("methodName", "")});
        this.methodName.doFillIntoGrid((Object)composite);
        this.methodName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewInterceptorWizardPage.this.onMethodNameChange();
                NewInterceptorWizardPage.this.doStatusUpdate();
            }
        });
    }

    protected void createRegisterInBeansXML(Composite composite) {
        if (!this.mayBeRegisteredInBeansXML) {
            return;
        }
        this.registerInBeansXML.create(composite);
    }

    void setInterceptorBindings(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.interceptorBindingsProvider.setProject(null);
        if (root != null && (cdi = NewCDIAnnotationWizardPage.getCDIProject(jp = root.getJavaProject())) != null) {
            this.interceptorBindingsProvider.setProject(cdi);
        }
        this.interceptorBindingsProvider.setPackageFragment(this.getPackageFragment());
    }

    void onMethodNameChange() {
        String methodName = this.methodName.getValueAsString();
        this.methodNameStatus = new StatusInfo();
        if (methodName.length() == 0) {
            this.methodNameStatus.setError(CDIUIMessages.MESSAGE_METHOD_NAME_EMPTY);
            return;
        }
        IStatus val = JavaConventionsUtil.validateMethodName((String)methodName, null);
        if (val != null && val.getSeverity() == 4) {
            this.methodNameStatus.setError(NLS.bind((String)CDIUIMessages.MESSAGE_METHOD_NAME_NOT_VALID, (Object)val.getMessage()));
        }
    }

    protected IMethod createAroundInvokeMethod(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        String methodName = "" + this.methodName.getValue();
        imports.addImport("javax.interceptor.InvocationContext");
        imports.addImport("javax.interceptor.AroundInvoke");
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = this.isAddComments();
        String access = "public";
        String javatype = "Object";
        String methodHeader = "@AroundInvoke" + lineDelimiter + access + " " + javatype + " " + methodName + "(InvocationContext ic) throws Exception";
        String stub = null;
        if (!type.isInterface()) {
            methodHeader = String.valueOf(methodHeader) + " {" + lineDelimiter;
            stub = String.valueOf(methodHeader) + "}" + lineDelimiter;
        } else {
            stub = methodHeader = String.valueOf(methodHeader) + ";" + lineDelimiter;
        }
        IMethod m = type.createMethod(stub, null, true, null);
        this.editMethod(cu, m, methodHeader, "return null;", lineDelimiter);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editMethod(ICompilationUnit cu, IMethod m, String methodHeader, String methodContent, String lineDelimiter) throws CoreException {
        String formattedContent;
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = m.getSourceRange();
        IBuffer buf = cu.getBuffer();
        StringBuffer sb = new StringBuffer(lineDelimiter);
        if (this.isAddComments()) {
            String methodComment = CodeGeneration.getMethodComment((IMethod)m, null, (String)lineDelimiter);
            sb.append(methodComment);
        }
        sb.append(methodHeader);
        if (methodContent != null) {
            sb.append(methodContent).append("}").append(lineDelimiter);
        }
        if ((formattedContent = JavaBeanGenerator.codeFormat2((int)4, (String)sb.toString(), (int)1, (String)lineDelimiter, (IJavaProject)cu.getJavaProject())) != null && formattedContent.startsWith("\t")) {
            formattedContent = formattedContent.substring(1);
        }
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        IStatus[] ns = new IStatus[status.length + 2];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.methodNameStatus;
        ns[status.length + 1] = this.interceptorBindingsStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    protected IStatus packageChanged() {
        IStatus result = super.packageChanged();
        if (result != null && result.isOK()) {
            this.interceptorBindingsProvider.setPackageFragment(this.getPackageFragment());
        }
        this.registerInBeansXML.validate();
        return result;
    }

    public boolean isToBeRegisteredInBeansXML() {
        return this.registerInBeansXML.isSelected();
    }

    protected IStatus typeNameChanged() {
        IStatus result = super.typeNameChanged();
        this.registerInBeansXML.validate();
        return result;
    }
}

