/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.time;

import com.ocpsoft.pretty.time.Duration;
import com.ocpsoft.pretty.time.TimeFormat;
import com.ocpsoft.pretty.time.TimeUnit;
import com.ocpsoft.pretty.time.units.Century;
import com.ocpsoft.pretty.time.units.Day;
import com.ocpsoft.pretty.time.units.Decade;
import com.ocpsoft.pretty.time.units.Hour;
import com.ocpsoft.pretty.time.units.JustNow;
import com.ocpsoft.pretty.time.units.Millennium;
import com.ocpsoft.pretty.time.units.Millisecond;
import com.ocpsoft.pretty.time.units.Minute;
import com.ocpsoft.pretty.time.units.Month;
import com.ocpsoft.pretty.time.units.Second;
import com.ocpsoft.pretty.time.units.Week;
import com.ocpsoft.pretty.time.units.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyTime {
    private volatile Date reference;
    private volatile List<TimeUnit> timeUnits;
    private volatile Locale locale = Locale.getDefault();

    public PrettyTime() {
        this.initTimeUnits();
    }

    public PrettyTime(Date reference) {
        this();
        this.setReference(reference);
    }

    public PrettyTime(Locale locale) {
        this.setLocale(locale);
        this.initTimeUnits();
    }

    public PrettyTime(Date reference, Locale locale) {
        this(locale);
        this.setReference(reference);
    }

    public Duration approximateDuration(Date then) {
        Date ref = this.reference;
        if (null == ref) {
            ref = new Date();
        }
        long difference = then.getTime() - ref.getTime();
        return this.calculateDuration(difference);
    }

    private void initTimeUnits() {
        this.timeUnits = new ArrayList<TimeUnit>();
        this.timeUnits.add(new JustNow(this.locale));
        this.timeUnits.add(new Millisecond(this.locale));
        this.timeUnits.add(new Second(this.locale));
        this.timeUnits.add(new Minute(this.locale));
        this.timeUnits.add(new Hour(this.locale));
        this.timeUnits.add(new Day(this.locale));
        this.timeUnits.add(new Week(this.locale));
        this.timeUnits.add(new Month(this.locale));
        this.timeUnits.add(new Year(this.locale));
        this.timeUnits.add(new Decade(this.locale));
        this.timeUnits.add(new Century(this.locale));
        this.timeUnits.add(new Millennium(this.locale));
    }

    private Duration calculateDuration(long difference) {
        long absoluteDifference = Math.abs(difference);
        ArrayList<TimeUnit> units = new ArrayList<TimeUnit>(this.timeUnits.size());
        units.addAll(this.timeUnits);
        Duration result = new Duration();
        for (int i = 0; i < units.size(); ++i) {
            boolean isLastUnit;
            TimeUnit unit = (TimeUnit)units.get(i);
            long millisPerUnit = Math.abs(unit.getMillisPerUnit());
            long quantity = Math.abs(unit.getMaxQuantity());
            boolean bl = isLastUnit = i == units.size() - 1;
            if (0L == quantity && !isLastUnit) {
                quantity = ((TimeUnit)units.get(i + 1)).getMillisPerUnit() / unit.getMillisPerUnit();
            }
            if (millisPerUnit * quantity <= absoluteDifference && !isLastUnit) continue;
            result.setUnit(unit);
            if (millisPerUnit > absoluteDifference) {
                result.setQuantity(this.getSign(difference, absoluteDifference));
            } else {
                result.setQuantity(difference / millisPerUnit);
            }
            result.setDelta(difference - result.getQuantity() * millisPerUnit);
            break;
        }
        return result;
    }

    private long getSign(long difference, long absoluteDifference) {
        if (0L > difference) {
            return -1L;
        }
        return 1L;
    }

    public List<Duration> calculatePreciseDuration(Date then) {
        if (null == this.reference) {
            this.reference = new Date();
        }
        ArrayList<Duration> result = new ArrayList<Duration>();
        long difference = then.getTime() - this.reference.getTime();
        Duration duration = this.calculateDuration(difference);
        result.add(duration);
        while (0L < duration.getDelta()) {
            duration = this.calculateDuration(duration.getDelta());
            result.add(duration);
        }
        return result;
    }

    public String format(Duration duration) {
        TimeFormat format = duration.getUnit().getFormat();
        return format.format(duration);
    }

    public String format(Date then) {
        if (then == null) {
            then = new Date();
        }
        Duration d = this.approximateDuration(then);
        return this.format(d);
    }

    public Date getReference() {
        return this.reference;
    }

    public void setReference(Date timestamp) {
        this.reference = timestamp;
    }

    public List<TimeUnit> getUnits() {
        return Collections.unmodifiableList(this.timeUnits);
    }

    public void setUnits(List<TimeUnit> units) {
        this.timeUnits = units;
    }

    public void setUnits(TimeUnit ... units) {
        this.timeUnits = Arrays.asList(units);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

