/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.databinding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jboss.tools.common.databinding.IObservablePojo;

public abstract class ObservablePojo
implements IObservablePojo {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (!this.contains(listener)) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.contains(listener)) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removeAllPropertyChangeListeners() {
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            this.getPropertyChangeSupport().removePropertyChangeListener(listener);
            ++n2;
        }
    }

    protected boolean contains(PropertyChangeListener listener) {
        boolean contains = false;
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener registeredListener = propertyChangeListenerArray[n2];
            if (registeredListener == listener) {
                contains = true;
                break;
            }
            ++n2;
        }
        return contains;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public void dispose() {
        this.removeAllPropertyChangeListeners();
    }
}

