/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.impl;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.jboss.tools.common.java.IJavaAnnotation;

public class AnnotationLiteral
implements IJavaAnnotation {
    IResource declaringResource;
    IType annotationType;
    String source;
    ISourceRange range;
    IMemberValuePair[] memberValues = new IMemberValuePair[0];
    IJavaElement parent;

    public AnnotationLiteral(IResource declaringResource, String source, ISourceRange range, IMemberValuePair[] memberValues, IType annotationType) {
        this.declaringResource = declaringResource;
        this.source = source;
        this.range = range;
        this.memberValues = memberValues;
        this.annotationType = annotationType;
    }

    public AnnotationLiteral(IResource declaringResource, int offset, int length, Object value, int valueType, IType annotationType) {
        this.declaringResource = declaringResource;
        this.range = new SourceRange(offset, length);
        if (value != null) {
            this.memberValues = new IMemberValuePair[]{this.createPair("value", value, valueType)};
        }
        this.annotationType = annotationType;
    }

    public void addMemberValuePair(String name, Object value, int valueType) {
        IMemberValuePair[] pairs = new IMemberValuePair[this.memberValues.length + 1];
        System.arraycopy(this.memberValues, 0, pairs, 0, this.memberValues.length);
        pairs[this.memberValues.length] = this.createPair(name, value, valueType);
        this.memberValues = pairs;
    }

    private IMemberValuePair createPair(String name, Object value, int valueType) {
        return new MemberValuePair(name, value, valueType);
    }

    @Override
    public int getStartPosition() {
        return this.range == null ? -1 : this.range.getOffset();
    }

    @Override
    public int getLength() {
        return this.range == null ? -1 : this.range.getLength();
    }

    @Override
    public IResource getResource() {
        return this.declaringResource;
    }

    @Override
    public String getTypeName() {
        if (this.annotationType != null) {
            return this.annotationType.getFullyQualifiedName();
        }
        return null;
    }

    @Override
    public IType getType() {
        return this.annotationType;
    }

    @Override
    public IMember getParentMember() {
        return null;
    }

    @Override
    public IJavaElement getParentElement() {
        return this.parent;
    }

    public void setParentElement(IJavaElement element) {
        this.parent = element;
    }

    @Override
    public IMemberValuePair[] getMemberValuePairs() {
        return this.memberValues;
    }
}

