/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.preferences;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public abstract class SeverityPreferences {
    public static final String ENABLE_BLOCK_PREFERENCE_NAME = "org.jboss.tools.common.validator.enableBlock";
    public static final String MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME = "org.jboss.tools.common.validator.problem.markersBlock";
    public static final int DEFAULT_MAX_NUMBER_OF_MARKERS_PER_FILE = 20;
    public static final String WRONG_BUILDER_ORDER_PREFERENCE_NAME = "org.jboss.tools.common.validator.problem.wrongBuilderOrder";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLE = "enabled";
    public static final String DISABLE = "disabled";

    protected abstract Set<String> getSeverityOptionNames();

    protected abstract String createSeverityOption(String var1);

    protected abstract String getPluginId();

    public IEclipsePreferences getProjectPreferences(IProject project) {
        return new ProjectScope(project).getNode(this.getPluginId());
    }

    public IEclipsePreferences getDefaultPreferences() {
        return new DefaultScope().getNode(this.getPluginId());
    }

    public IEclipsePreferences getInstancePreferences() {
        return new InstanceScope().getNode(this.getPluginId());
    }

    public String getProjectPreference(IProject project, String key) {
        IEclipsePreferences p = this.getProjectPreferences(project);
        if (p == null) {
            return null;
        }
        String value = p.get(key, null);
        return value != null ? value : this.getInstancePreference(key);
    }

    public int getMaxNumberOfProblemMarkersPerResource(IProject project) {
        IEclipsePreferences p = this.getProjectPreferences(project);
        if (p == null) {
            return 0;
        }
        String value = p.get(MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME, null);
        if (value != null) {
            return p.getInt(MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME, 0);
        }
        p = this.getInstancePreferences();
        String string = value = p == null ? null : p.get(MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME, null);
        if (value != null) {
            return p.getInt(MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME, 0);
        }
        p = this.getDefaultPreferences();
        return p.getInt(MAX_NUMBER_OF_MARKERS_PREFERENCE_NAME, 0);
    }

    public boolean isEnabled(IProject project) {
        IEclipsePreferences p = this.getProjectPreferences(project);
        if (p == null) {
            return false;
        }
        String value = p.get(ENABLE_BLOCK_PREFERENCE_NAME, null);
        if (value != null) {
            return ENABLE.equals(value) || p.getBoolean(ENABLE_BLOCK_PREFERENCE_NAME, false);
        }
        p = this.getInstancePreferences();
        String string = value = p == null ? null : p.get(ENABLE_BLOCK_PREFERENCE_NAME, null);
        if (value != null) {
            return ENABLE.equals(value) || p.getBoolean(ENABLE_BLOCK_PREFERENCE_NAME, false);
        }
        p = this.getDefaultPreferences();
        return ENABLE.equals(p.get(ENABLE_BLOCK_PREFERENCE_NAME, null)) || p.getBoolean(ENABLE_BLOCK_PREFERENCE_NAME, false);
    }

    public String getBuilderOrderPreference(IProject project) {
        IEclipsePreferences p = this.getProjectPreferences(project);
        if (p == null) {
            return null;
        }
        String value = p.get(WRONG_BUILDER_ORDER_PREFERENCE_NAME, null);
        if (value != null) {
            return value;
        }
        p = this.getInstancePreferences();
        String string = value = p == null ? null : p.get(WRONG_BUILDER_ORDER_PREFERENCE_NAME, null);
        if (value != null) {
            return value;
        }
        p = this.getDefaultPreferences();
        return p.get(WRONG_BUILDER_ORDER_PREFERENCE_NAME, null);
    }

    public String getInstancePreference(String key) {
        IEclipsePreferences p = this.getInstancePreferences();
        String value = p == null ? null : p.get(key, null);
        return value != null ? value : this.getDefaultPreference(key);
    }

    public String getDefaultPreference(String key) {
        IEclipsePreferences p = this.getDefaultPreferences();
        if (p == null) {
            return null;
        }
        return p.get(key, null);
    }
}

