/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.util.UniquePaths;
import org.w3c.dom.Element;

public class ELReference
implements ITextSourceReference {
    private IPath path;
    private int length;
    private int lineNumber;
    private int startPosition;
    private Set<IMarker> markers;
    private boolean needToInitMarkers = false;
    private String source;
    private String elMarkerGroupID;
    private static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];

    public ELReference() {
    }

    public ELReference(String elMarkerGroupID) {
        this.elMarkerGroupID = elMarkerGroupID;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public IFile getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
    }

    public void setResource(IFile resource) {
        if (resource != null) {
            this.path = UniquePaths.getInstance().intern(resource.getFullPath());
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = UniquePaths.getInstance().intern(path);
    }

    public String getSourceText() {
        if (this.source == null) {
            this.source = this.getText();
        }
        return this.source;
    }

    public int getStartPossitionOfFirstEL() {
        ELExpression[] els = this.getEl();
        if (els.length > 0) {
            return this.startPosition + els[0].getStartPosition();
        }
        return this.startPosition;
    }

    public ELExpression[] init(String text) {
        ELParser parser = ELParserUtil.getJbossFactory().createParser();
        ELModel model = parser.parse(text);
        return this.setEl(model.getInstances());
    }

    public ELExpression[] getEl() {
        ELExpression[] el = null;
        String text = this.getSourceText();
        el = text.length() > 0 ? this.init(text) : new ELExpression[]{};
        return el;
    }

    private String getText() {
        String text = FileUtil.getContentFromEditorOrFile((IFile)this.getResource());
        if (text != null && this.getStartPosition() >= 0 && this.getLength() >= 0 && text.length() >= this.getStartPosition() + this.getLength()) {
            this.source = text.substring(this.getStartPosition(), this.getStartPosition() + this.getLength());
            return this.source;
        }
        this.source = "";
        return "";
    }

    public ELExpression[] setEl(List<ELInstance> insts) {
        HashSet<ELExpression> exps = new HashSet<ELExpression>();
        for (ELInstance el : insts) {
            exps.add(el.getExpression());
        }
        return exps.toArray(new ELExpression[0]);
    }

    private void initMarkers() {
        if (this.markers == null && this.needToInitMarkers) {
            IFile file = this.getResource();
            if (file != null) {
                IMarker[] markers = null;
                try {
                    markers = file.findMarkers(null, true, 2);
                }
                catch (CoreException e) {
                    ELCorePlugin.getDefault().logError(e);
                }
                int i = 0;
                while (i < markers.length) {
                    String groupName = markers[i].getAttribute("groupName", null);
                    if (groupName != null && groupName.equals(this.elMarkerGroupID)) {
                        int start = markers[i].getAttribute("charStart", -1);
                        int end = markers[i].getAttribute("charEnd", -1);
                        if (start >= this.startPosition && end <= this.startPosition + this.length) {
                            this.addMarker(markers[i]);
                        }
                    }
                    ++i;
                }
            }
            this.needToInitMarkers = false;
        }
    }

    public List<SyntaxError> getSyntaxErrors() {
        ELParser parser = ELParserUtil.getJbossFactory().createParser();
        String text = this.getSourceText();
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        ELModel model = parser.parse(text);
        return model.getSyntaxErrors();
    }

    public String getMarkerGroupId() {
        return this.elMarkerGroupID;
    }

    public synchronized void setNeedToInitMarkers(boolean needToInitMarkers) {
        this.needToInitMarkers = needToInitMarkers;
    }

    public synchronized void addMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.markers == null) {
            this.markers = new HashSet<IMarker>();
        }
        this.markers.add(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMarkers() {
        Set<IMarker> aMarkers = null;
        ELReference eLReference = this;
        synchronized (eLReference) {
            this.initMarkers();
            if (this.markers == null) {
                return;
            }
            aMarkers = this.markers;
            this.markers = null;
        }
        for (IMarker marker : aMarkers) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError(e);
            }
        }
    }

    public synchronized void store(Element element, Map<String, String> pathIds) {
        element.setAttribute("path", ELReference.getAlias(pathIds, this.path.toString()));
        element.setAttribute("offset", "" + this.startPosition);
        element.setAttribute("length", "" + this.length);
    }

    public static String getAlias(Map<String, String> pathAliases, String path) {
        String result = pathAliases.get(path);
        if (result == null) {
            result = "%" + pathAliases.size();
            pathAliases.put(path, result);
        }
        return result;
    }

    public static String getPath(Map<String, String> pathAliases, String alias) {
        return pathAliases.containsKey(alias) ? pathAliases.get(alias) : alias;
    }

    public synchronized void load(Element element, Map<String, String> pathAliases) {
        this.path = new Path(ELReference.getPath(pathAliases, element.getAttribute("path")));
        this.setPath(this.path);
        this.startPosition = new Integer(element.getAttribute("offset"));
        this.length = new Integer(element.getAttribute("length"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        ELReference el = (ELReference)obj;
        return this.path.equals((Object)el.path) && this.startPosition == el.startPosition;
    }

    public int hashCode() {
        return this.path.hashCode() + this.startPosition;
    }

    public ELModel getELModel() {
        ELExpression[] exprs = this.getEl();
        if (exprs.length > 0) {
            return exprs[0].getModel();
        }
        return null;
    }
}

