/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.model;

import java.util.List;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELMethodInvocation;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELParameters;
import org.jboss.tools.common.el.core.parser.LexicalToken;

public class ELUtil {
    public static ELInstance findInstance(ELModel model, int offset) {
        if (model == null) {
            return null;
        }
        List<ELInstance> is = model.getInstances();
        for (ELInstance i : is) {
            LexicalToken c;
            if (i.getStartPosition() >= offset || !((c = i.getCloseInstanceToken()) != null ? c.getStart() >= offset : i.getEndPosition() >= offset)) continue;
            return i;
        }
        return null;
    }

    public static ELInvocationExpression findExpression(ELModel model, int offset) {
        Object result = null;
        int off = -1;
        List<ELInstance> is = model.getInstances();
        for (ELInstance i : is) {
            ELParameters p;
            ELExpression expr = i.getExpression();
            if (expr == null || expr.getFirstToken().getStart() > offset) continue;
            List<ELInvocationExpression> invs = expr.getInvocations();
            for (ELInvocationExpression inv : invs) {
                if (inv.getStartPosition() > offset || inv.getEndPosition() < offset || off >= inv.getStartPosition()) continue;
                ELInvocationExpression res = inv;
                off = inv.getStartPosition();
                ELInvocationExpression l = inv.getLeft();
                while (l != null && l.getEndPosition() >= offset) {
                    res = l;
                    l = l.getLeft();
                }
                if (result != null && result.toString().length() <= res.toString().length()) continue;
                result = res;
            }
            if (result == null) continue;
            if (result instanceof ELMethodInvocation && ((ELMethodInvocation)result).getParameters() != null && (p = ((ELMethodInvocation)result).getParameters()).getStartPosition() < offset && p.getEndPosition() > offset) {
                result = null;
            }
            return result;
        }
        return result;
    }
}

