/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.Var;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElVarSearcher {
    private static final String VAR_ATTRIBUTE_NAME = "var";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private IFile file;
    private ELCompletionEngine engine;

    public ElVarSearcher(IFile file, ELCompletionEngine engine) {
        this.file = file;
        this.engine = engine;
    }

    public ElVarSearcher(ELCompletionEngine engine) {
        this(null, engine);
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public static Node getNode(ITextViewer viewer, int offset) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
        if (treeNode instanceof Node) {
            return (Node)treeNode;
        }
        return null;
    }

    public static Node getNode(IFile file, int offset) {
        IndexedRegion treeNode = ElVarSearcher.getNodeAt(file, offset);
        if (treeNode instanceof Node) {
            return (Node)treeNode;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexedRegion getNodeAt(IFile file, int documentOffset) {
        node = null;
        if (file == null) return node;
        mm = StructuredModelManager.getModelManager();
        model = null;
        if (mm == null) return node;
        try {
            try {
                model = mm.getModelForRead(file);
                if (model == null) return node;
                lastOffset = documentOffset;
                node = model.getIndexedRegion(documentOffset);
                if (true) ** GOTO lbl15
                do {
                    node = model.getIndexedRegion(--lastOffset);
lbl15:
                    // 2 sources

                    if (node != null) return node;
                } while (lastOffset >= 0);
                return node;
            }
            catch (IOException e) {
                ELCorePlugin.getDefault().logError(e);
                node = null;
                if (model == null) return node;
                model.releaseFromRead();
                return node;
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError(e);
                node = null;
                if (model == null) return node;
                model.releaseFromRead();
                return node;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public List<Var> findAllVars(ITextViewer viewer, int offset) {
        Node node = ElVarSearcher.getNode(viewer, offset);
        if (node != null) {
            return this.findAllVars(node);
        }
        return Collections.emptyList();
    }

    public List<Var> findAllVars(IFile file, int offset) {
        return ElVarSearcher.findAllVars(file, offset, this.engine.getParserFactory());
    }

    public static List<Var> findAllVars(ELContext context, int offset, ELResolver resolver) {
        Node node = ElVarSearcher.getNode(context.getResource(), offset);
        if (node != null) {
            List<Var> result = ElVarSearcher.findAllVars(node, resolver.getParserFactory());
            for (Var v : result) {
                v.setFile(context.getResource());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<Var> findAllVars(IFile file, int offset, ELParserFactory factory) {
        Node node = ElVarSearcher.getNode(file, offset);
        if (node != null) {
            List<Var> result = ElVarSearcher.findAllVars(node, factory);
            for (Var v : result) {
                v.setFile(file);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<Var> findAllVars(ITextViewer viewer, int offset, ELParserFactory factory) {
        Node node = ElVarSearcher.getNode(viewer, offset);
        if (node != null) {
            return ElVarSearcher.findAllVars(node, factory);
        }
        return Collections.emptyList();
    }

    public List<Var> findAllVars(Node node) {
        return ElVarSearcher.findAllVars(node, this.engine.getParserFactory());
    }

    public static List<Var> findAllVars(Node node, ELParserFactory factory) {
        ArrayList<Var> vars = new ArrayList<Var>();
        Node parentNode = node;
        while (parentNode != null) {
            Var var = ElVarSearcher.findVar(parentNode, factory);
            if (var != null) {
                vars.add(0, var);
            }
            parentNode = parentNode.getParentNode();
        }
        return vars;
    }

    public Var findVar(IFile file, int offset) {
        Node node = ElVarSearcher.getNode(file, offset);
        if (node != null) {
            Var result = this.findVar(node);
            if (result != null) {
                result.setFile(file);
            }
            return result;
        }
        return null;
    }

    public Var findVar(Node node) {
        return ElVarSearcher.findVar(node, this.engine.getParserFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Var findVar(Node node, ELParserFactory factory) {
        if (factory != null && node != null && 1 == node.getNodeType()) {
            Element element;
            Element element2 = element = (Element)node;
            synchronized (element2) {
                if (element.hasAttribute(VAR_ATTRIBUTE_NAME)) {
                    String var = element.getAttribute(VAR_ATTRIBUTE_NAME);
                    int declOffset = 0;
                    int declLength = 0;
                    Attr varAttr = element.getAttributeNode(VAR_ATTRIBUTE_NAME);
                    if (varAttr instanceof IDOMAttr) {
                        int varNameStart = ((IDOMAttr)varAttr).getNameRegionStartOffset();
                        int varNameEnd = ((IDOMAttr)varAttr).getNameRegionEndOffset();
                        declOffset = varNameStart;
                        declLength = varNameEnd - varNameStart;
                    }
                    if (!"".equals(var = var.trim()) && element.hasAttribute(VALUE_ATTRIBUTE_NAME)) {
                        String value = element.getAttribute(VALUE_ATTRIBUTE_NAME);
                        Var newVar = new Var(factory, var, value = value.trim(), declOffset, declLength);
                        if (newVar.getElToken() != null) {
                            return newVar;
                        }
                    }
                }
            }
        }
        return null;
    }

    public Var findVarForEl(String el, ELContext context, List<Var> vars, boolean initializeNestedVars) {
        if (vars != null) {
            ArrayList<Var> parentVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (!this.isRelevantVar(var, el, context, vars, parentVars, initializeNestedVars)) continue;
                return var;
            }
        }
        return null;
    }

    public List<Var> findVarsForEl(String el, ELContext context, List<Var> vars, boolean initializeNestedVars) {
        ArrayList<Var> result = new ArrayList<Var>();
        ArrayList<Var> parentVars = new ArrayList<Var>();
        for (Var var : vars) {
            if (!this.isRelevantVar(var, el, context, vars, parentVars, initializeNestedVars)) continue;
            result.add(var);
        }
        return result;
    }

    private boolean isRelevantVar(Var var, String el, ELContext context, List<Var> vars, ArrayList<Var> parentVars, boolean initializeNestedVars) {
        String varName;
        boolean result = false;
        ELExpression token = var.getElToken();
        if (token != null && !token.getText().endsWith(".") && (el.equals(varName = var.getName()) || el.startsWith(String.valueOf(varName.trim()) + "."))) {
            if (var.getElToken() != null && initializeNestedVars) {
                ELContext c = context;
                var.getFile().equals((Object)context.getResource());
                Var parentVar = this.findVarForEl(var.getElToken().getText(), c, parentVars, true);
                if (parentVar != null) {
                    ELExpression resolvedToken = parentVar.getResolvedElToken();
                    if (resolvedToken == null && parentVar.getElToken() != null) {
                        try {
                            this.engine.resolveELOperand(this.file, context, var.getElToken(), true, parentVars, this, var.getRegion() == null ? 0 : var.getRegion().getOffset());
                            resolvedToken = parentVar.getResolvedElToken();
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            ELCorePlugin.getPluginLog().logError((Throwable)e);
                        }
                        catch (BadLocationException e) {
                            ELCorePlugin.getPluginLog().logError((Throwable)e);
                        }
                    }
                    if (resolvedToken != null) {
                        String newValue;
                        String oldText = var.getElToken().getText();
                        var.value = newValue = "#{" + resolvedToken.getText() + oldText.substring(parentVar.getName().length()) + "}";
                        var.elToken = var.parseEl(newValue);
                    }
                }
            }
            result = true;
        }
        parentVars.add(var);
        return result;
    }
}

