/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import org.jboss.tools.common.el.core.model.ELArgument;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELObjectImpl;

public class ELArgumentImpl
extends ELObjectImpl
implements ELArgument {
    ELExpressionImpl argument;

    @Override
    public ELExpressionImpl getArgument() {
        return this.argument;
    }

    @Override
    public LexicalToken getOpenArgumentToken() {
        LexicalToken result = this.getFirstToken();
        if (result != null && result.getType() == 10) {
            return result;
        }
        return null;
    }

    @Override
    public LexicalToken getCloseArgumentToken() {
        LexicalToken result = this.getLastToken();
        if (result != null && result.getType() == 11) {
            return result;
        }
        return null;
    }

    @Override
    public void addChild(ELObjectImpl child) {
        if (!(child instanceof ELExpressionImpl)) {
            throw new IllegalArgumentException("EL argument can have only EL expression as its child.");
        }
        this.setArgument((ELExpressionImpl)child);
    }

    public void setArgument(ELExpressionImpl arg) {
        if (this.argument == arg) {
            return;
        }
        if (this.argument != null) {
            this.removeChild(this.argument);
        }
        if (arg != null) {
            super.addChild(arg);
        }
        this.argument = arg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getOpenArgumentToken() != null) {
            sb.append(this.getOpenArgumentToken().getText());
        }
        if (this.argument != null) {
            sb.append(this.argument.toString());
        }
        if (this.getCloseArgumentToken() != null) {
            sb.append(this.getCloseArgumentToken().getText());
        }
        return sb.toString();
    }

    @Override
    public ELObjectType getType() {
        return ELObjectType.EL_ARGUMENT;
    }
}

