/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELObjectImpl;

public class ELArrayImpl
extends ELExpressionImpl {
    List<ELExpression> values = new ArrayList<ELExpression>();

    public LexicalToken getOpenParametersToken() {
        LexicalToken result = this.getFirstToken();
        if (result != null && result.getType() == 16) {
            return result;
        }
        return null;
    }

    public LexicalToken getCloseParametersToken() {
        LexicalToken result = this.getLastToken();
        if (result != null && result.getType() == 17) {
            return result;
        }
        return null;
    }

    public List<ELExpression> getValues() {
        return this.values;
    }

    @Override
    public void addChild(ELObjectImpl child) {
        if (!(child instanceof ELExpressionImpl)) {
            throw new IllegalArgumentException("EL array can have only EL expressions as its children.");
        }
        this.addValue((ELExpressionImpl)child);
    }

    public void addValue(ELExpressionImpl param) {
        super.addChild(param);
        this.values.add(param);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        LexicalToken t = this.getOpenParametersToken();
        if (t != null) {
            sb.append(t.getText());
        }
        boolean first = true;
        for (ELExpression p : this.values) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(p.toString());
        }
        t = this.getCloseParametersToken();
        if (t != null) {
            sb.append(t.getText());
        }
        return sb.toString();
    }

    @Override
    public ELObjectType getType() {
        return ELObjectType.EL_ARRAY;
    }

    @Override
    public void collectInvocations(List<ELInvocationExpression> list) {
        if (this.values != null) {
            for (ELExpression expr : this.values) {
                ((ELExpressionImpl)expr).collectInvocations(list);
            }
        }
    }
}

