/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.parser.Tokenizer;

public class StringTokenDescription
implements ITokenDescription {
    public static final int STRING = 5;
    public static StringTokenDescription INSTANCE = new StringTokenDescription();

    @Override
    public String getName() {
        return ElCoreMessages.StringTokenDescription_Name;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean isStart(Tokenizer tokenizer, int offset) {
        char ch = tokenizer.lookUpChar(offset);
        return ch == '\"' || ch == '\'';
    }

    @Override
    public boolean read(Tokenizer tokenizer, int offset) {
        char ch;
        char chE = ch = tokenizer.readNextChar();
        int i = offset;
        while (ch != '\u0000') {
            ++i;
            ch = tokenizer.readNextChar();
            if (ch == '\\') {
                ++i;
                ch = tokenizer.readNextChar();
                continue;
            }
            if (ch != chE) continue;
            ++i;
            break;
        }
        tokenizer.addToken(this.getType(), offset, i);
        if (ch == '\u0000') {
            SyntaxError error = new SyntaxError(offset, 301);
            error.setProblem(ElCoreMessages.StringTokenDescription_StringIsNotClosed);
            tokenizer.addSyntaxError(error);
        }
        return i > offset;
    }
}

