/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.ui.internal.info;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.internal.text.html.SubstitutionTextReader;

public class HTMLAnchorProcessor
extends SubstitutionTextReader {
    private static final String EMPTY_STRING = "";
    Set<String> fEnabledProtocols = new HashSet<String>(2);
    private boolean fIgnoredAnchor = false;

    public HTMLAnchorProcessor(Reader reader, String[] enabledProtocols) {
        super((Reader)new PushbackReader(reader));
        if (enabledProtocols != null) {
            String[] stringArray = enabledProtocols;
            int n = enabledProtocols.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (p != null && p.trim().length() > 0) {
                    this.fEnabledProtocols.add(p.trim().toLowerCase());
                }
                ++n2;
            }
        }
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        return null;
    }

    private String processHTMLTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch = this.nextChar();
            while (ch != -1 && ch != 62) {
                buf.append((char)ch);
                ch = this.nextChar();
                if (ch == 34) {
                    buf.append((char)ch);
                    ch = this.nextChar();
                    while (ch != -1 && ch != 34) {
                        buf.append((char)ch);
                        ch = this.nextChar();
                    }
                }
                if (ch != 60 || HTMLAnchorProcessor.isInComment(buf)) continue;
                this.unread(ch);
                return String.valueOf('<') + buf.toString();
            }
            if (ch == -1) {
                return null;
            }
            if (!HTMLAnchorProcessor.isInComment(buf) || HTMLAnchorProcessor.isCommentEnd(buf)) break;
            buf.append((char)ch);
        }
        return this.internalProcessTag(buf.toString());
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    private static boolean isInComment(StringBuffer buf) {
        return buf.length() >= 3 && "!--".equals(buf.substring(0, 3));
    }

    private static boolean isCommentEnd(StringBuffer buf) {
        int tagLen = buf.length();
        return tagLen >= 5 && "--".equals(buf.substring(tagLen - 2));
    }

    private String internalProcessTag(String tagText) {
        if (tagText == null || tagText.length() == 0) {
            return EMPTY_STRING;
        }
        String html = tagText.toLowerCase();
        String tag = html;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        }
        if ("a".equals(html) || html.length() > 2 && html.startsWith("a") && Character.isWhitespace(html.charAt(1))) {
            return this.startAnchor(html) ? EMPTY_STRING : String.valueOf('<') + tagText + '>';
        }
        if ("/a".equals(html)) {
            return this.stopAnchor() ? EMPTY_STRING : String.valueOf('<') + tagText + '>';
        }
        return String.valueOf('<') + tagText + '>';
    }

    private boolean startAnchor(String html) {
        int equalStart;
        this.fIgnoredAnchor = true;
        int hrefStart = html.indexOf("href");
        if (hrefStart != -1 && (equalStart = html.indexOf(61, hrefStart)) != -1 && "href".equals(html.substring(hrefStart, equalStart).trim())) {
            int valueStart = equalStart + 1;
            while (valueStart < html.length() && !Character.isLetterOrDigit(html.charAt(valueStart)) && ('\"' == html.charAt(valueStart) || '\'' == html.charAt(valueStart) || Character.isWhitespace(html.charAt(valueStart)))) {
                ++valueStart;
            }
            int end = html.indexOf(58, valueStart);
            if (end != -1) {
                String prot = html.substring(valueStart, end);
                this.fIgnoredAnchor = !this.fEnabledProtocols.contains(prot);
            }
        }
        return this.fIgnoredAnchor;
    }

    private boolean stopAnchor() {
        boolean result = this.fIgnoredAnchor;
        if (this.fIgnoredAnchor) {
            this.fIgnoredAnchor = false;
        }
        return result;
    }
}

