/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.ui.Messages;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;
import org.jboss.tools.common.jdt.debug.ui.actions.DiscoverRemoteApplicationAction;
import org.jboss.tools.common.jdt.debug.ui.actions.LaunchDialogAction;
import org.jboss.tools.common.jdt.debug.ui.actions.RemoteLaunchAction;
import org.jboss.tools.common.jdt.debug.ui.preferences.RemoteDebug;

public class RemoteDebugItems
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        Action action;
        ArrayList<Object> items = new ArrayList<Object>();
        List<RemoteDebug> remoteDebugs = RemoteDebugUIActivator.getDefault().getValidRemoteDebugs();
        VmModel[] models = RemoteDebugUIActivator.getDefault().getDebugModels((IProgressMonitor)new NullProgressMonitor());
        if (models != null) {
            VmModel[] vmModelArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                VmModel model = vmModelArray[n2];
                RemoteLaunchAction action2 = new RemoteLaunchAction(model.getPort());
                RemoteDebug remoteDebug = RemoteDebugUIActivator.findRemoteDebug(remoteDebugs, model.getPort());
                if (remoteDebug != null) {
                    String id = "org.jboss.tools.common.jdt.debug." + remoteDebug.getId();
                    action2.setActionDefinitionId(id);
                    if (remoteDebug.isShow()) {
                        String port;
                        String pid;
                        String text;
                        StringBuffer buffer = new StringBuffer();
                        if (remoteDebug.getDescription() != null && !remoteDebug.getDescription().isEmpty()) {
                            if (buffer.length() > 0) {
                                buffer.append(",");
                            }
                            buffer.append(remoteDebug.getDescription());
                        }
                        if ((text = model.getMainClass()) != null && !"<Unknown>".equals(text)) {
                            if (buffer.length() > 0) {
                                buffer.append(",main=");
                            }
                            buffer.append(text);
                        }
                        if ((pid = model.getPid()) != null) {
                            if (buffer.length() > 0) {
                                buffer.append(",pid=");
                            }
                            buffer.append(pid);
                        }
                        if ((port = model.getPort()) != null) {
                            if (buffer.length() > 0) {
                                buffer.append(",port=");
                            }
                            buffer.append(port);
                        }
                        action2.setText(buffer.toString());
                    } else {
                        action2.setText(model.getDisplayName());
                    }
                } else {
                    action2.setText(model.getDisplayName());
                }
                ActionContributionItem item = new ActionContributionItem((IAction)action2);
                items.add(item);
                ++n2;
            }
        }
        if (items.size() > 0) {
            items.add(new Separator());
        }
        if (!RemoteDebugUIActivator.getDefault().isDiscoverRemoteApplication()) {
            action = new DiscoverRemoteApplicationAction();
            String id = "org.jboss.tools.common.jdt.debug.ui.discover";
            action.setActionDefinitionId(id);
            action.setText(Messages.Discover_Remote_Applications);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            items.add(item);
        }
        action = new LaunchDialogAction();
        String id = "org.jboss.tools.common.jdt.debug.ui.configure";
        action.setActionDefinitionId(id);
        action.setText(Messages.RemoteDebugItems_Configure);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        items.add(item);
        if (items.size() > 0) {
            return items.toArray(new IContributionItem[0]);
        }
        return null;
    }
}

