/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.ui.launching.xpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.ui.Messages;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;
import org.jboss.tools.common.jdt.debug.ui.preferences.RemoteDebug;

public class JavaConnectTab
extends AbstractJavaMainTab {
    private static final String HOST_NAMES = "hostNames";
    private static final String DEFAULT_HOST = "defaultHost";
    private Button fAllowTerminateButton;
    private Composite fArgumentComposite;
    private IVMConnector fConnector;
    private Combo hostCombo;
    private Combo portCombo;
    private String[] items;
    private VmModel[] models;
    private Button defaultButton;
    private Group messageGroup;

    private void updateConnector() {
        String[] hostNames;
        this.getSelectedConnector();
        IDialogSettings dialogSettings = RemoteDebugUIActivator.getDefault().getDialogSettings();
        String names = dialogSettings.get(HOST_NAMES);
        if (names == null) {
            names = "localhost";
            dialogSettings.put(HOST_NAMES, names);
            hostNames = new String[]{names};
        } else {
            StringTokenizer tokenizer = new StringTokenizer(names, ",");
            HashSet<String> hostSets = new HashSet<String>();
            hostSets.add("localhost");
            while (tokenizer.hasMoreTokens()) {
                hostSets.add(tokenizer.nextToken());
            }
            hostNames = hostSets.toArray(new String[0]);
        }
        Composite hostComposite = new Composite(this.fArgumentComposite, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        hostComposite.setLayoutData((Object)gd);
        hostComposite.setLayout((Layout)new GridLayout(2, false));
        Label hostLabel = new Label(hostComposite, 0);
        gd = new GridData(4, 4, false, false);
        hostLabel.setLayoutData((Object)gd);
        hostLabel.setText(Messages.JavaConnectTab_Host);
        this.hostCombo = new Combo(hostComposite, 8);
        gd = new GridData(4, 4, true, false);
        this.hostCombo.setLayoutData((Object)gd);
        this.hostCombo.setItems(hostNames);
        String defaultHost = dialogSettings.get(DEFAULT_HOST);
        if (defaultHost == null) {
            defaultHost = "localhost";
            dialogSettings.put(DEFAULT_HOST, defaultHost);
        }
        this.hostCombo.setText(defaultHost);
        this.hostCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite portComposite = new Composite(this.fArgumentComposite, 0);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        portComposite.setLayoutData((Object)gd);
        portComposite.setLayout((Layout)new GridLayout(3, false));
        Label portLabel = new Label(portComposite, 0);
        gd = new GridData(4, 4, false, false);
        portLabel.setLayoutData((Object)gd);
        portLabel.setText(Messages.JavaConnectTab_Port);
        this.portCombo = new Combo(portComposite, 8);
        gd = new GridData(4, 4, true, false);
        this.portCombo.setLayoutData((Object)gd);
        this.refresh(defaultHost, false);
        this.portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button refreshButton = new Button(portComposite, 8);
        gd = new GridData(4, 4, false, false);
        refreshButton.setLayoutData((Object)gd);
        refreshButton.setText(Messages.JavaConnectTab_Refresh);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.refresh(JavaConnectTab.this.hostCombo.getText(), true);
                JavaConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateLaunchConfigurationDialog();
    }

    private void refresh(String defaultHost, boolean discover) {
        if (!discover) {
            boolean oldDiscoverPreferences = RemoteDebugUIActivator.getDefault().isDiscoverRemoteApplication();
            RemoteDebugUIActivator.getDefault().getPreferences().putBoolean("discoverRemoteApplication", false);
            this.models = RemoteDebugUIActivator.getDefault().getDebugModels((IProgressMonitor)new NullProgressMonitor());
            RemoteDebugUIActivator.getDefault().getPreferences().putBoolean("discoverRemoteApplication", oldDiscoverPreferences);
        } else {
            RemoteDebugUIActivator.getDefault().discoverRemoteApplication((IProgressMonitor)new NullProgressMonitor());
            this.models = RemoteDebugUIActivator.getDefault().getDebugModels((IProgressMonitor)new NullProgressMonitor());
        }
        this.refreshCombo();
    }

    private void refreshCombo() {
        this.items = new String[this.models.length];
        int i = 0;
        VmModel[] vmModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            String displayText;
            VmModel model = vmModelArray[n2];
            List<RemoteDebug> remoteDebugs = RemoteDebugUIActivator.getDefault().getValidRemoteDebugs();
            RemoteDebug remoteDebug = RemoteDebugUIActivator.findRemoteDebug(remoteDebugs, model.getPort());
            if (remoteDebug != null) {
                if (remoteDebug.isShow()) {
                    String port;
                    String pid;
                    String text;
                    StringBuffer buffer = new StringBuffer();
                    if (remoteDebug.getDescription() != null && !remoteDebug.getDescription().isEmpty()) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                        }
                        buffer.append(remoteDebug.getDescription());
                    }
                    if ((text = model.getMainClass()) != null && !"<Unknown>".equals(text)) {
                        if (buffer.length() > 0) {
                            buffer.append(",main=");
                        }
                        buffer.append(text);
                    }
                    if ((pid = model.getPid()) != null) {
                        if (buffer.length() > 0) {
                            buffer.append(",pid=");
                        }
                        buffer.append(pid);
                    }
                    if ((port = model.getPort()) != null) {
                        if (buffer.length() > 0) {
                            buffer.append(",port=");
                        }
                        buffer.append(port);
                    }
                    displayText = buffer.toString();
                } else {
                    displayText = model.getDisplayName();
                }
            } else {
                displayText = model.getDisplayName();
            }
            this.items[i++] = displayText;
            ++n2;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                JavaConnectTab.this.portCombo.setItems(JavaConnectTab.this.items);
                if (JavaConnectTab.this.items.length > 0) {
                    JavaConnectTab.this.portCombo.select(0);
                    JavaConnectTab.this.portCombo.setText(JavaConnectTab.this.items[0]);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite cgroup;
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)1808);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        Group group = SWTFactory.createGroup((Composite)comp, (String)Messages.JavaConnectTab_Connection_Properties_1, (int)2, (int)1, (int)768);
        this.fArgumentComposite = cgroup = SWTFactory.createComposite((Composite)group, (Font)font, (int)2, (int)1, (int)768);
        this.updateConnector();
        this.createVerticalSpacer(comp, 2);
        this.fAllowTerminateButton = this.createCheckButton(comp, Messages.JavaConnectTab__Allow_termination_of_remote_VM_6);
        this.fAllowTerminateButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.createVerticalSpacer(comp, 2);
        this.defaultButton = this.createCheckButton(comp, Messages.JavaConnectTab_SetAsDefault);
        this.defaultButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.createVerticalSpacer(comp, 2);
        this.messageGroup = new Group(comp, 0);
        this.messageGroup.setText(Messages.JavaConnectTab_Warning);
        this.messageGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(4, 4, true, false);
        this.messageGroup.setLayoutData((Object)gd);
        Label noteLabel = new Label((Composite)this.messageGroup, 0);
        gd = new GridData(1, 1, false, false);
        noteLabel.setLayoutData((Object)gd);
        Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        image.setBackground(noteLabel.getBackground());
        noteLabel.setImage(image);
        Text noteText = new Text((Composite)this.messageGroup, 72);
        gd = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)parent);
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)3);
        gc.dispose();
        noteText.setLayoutData((Object)gd);
        noteText.setText(Messages.JavaConnectTab_JDK_Required);
        this.messageGroup.setVisible(!RemoteDebugActivator.getDefault().isJdk());
        Button addJDK = new Button((Composite)this.messageGroup, 8);
        addJDK.setText(Messages.JavaConnectTab_Add_JDK);
        gd = new GridData(1, 0x1000000, false, false);
        addJDK.setLayoutData((Object)gd);
        addJDK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String preferenceId = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)JavaConnectTab.this.getShell(), (String)preferenceId, null, null);
                dialog.open();
                JavaConnectTab.this.refresh(JavaConnectTab.this.hostCombo.getText(), false);
                JavaConnectTab.this.updateLaunchConfigurationDialog();
                JavaConnectTab.this.messageGroup.setVisible(!RemoteDebugActivator.getDefault().isJdk());
            }
        });
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CONNECT_TAB);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAllowTerminateFromConfig(config);
        this.updateSetAsDefaultFromConfig(config);
    }

    private void updateSetAsDefaultFromConfig(ILaunchConfiguration config) {
        ILaunchConfiguration[] configs = RemoteDebugActivator.getDefault().getLaunchConfigurations();
        if (configs != null && configs.length == 1 && config instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)config;
            try {
                boolean isDefault = config.getAttribute("setAsDefault", false);
                if (!isDefault) {
                    wc.setAttribute("setAsDefault", true);
                    wc.doSave();
                }
            }
            catch (CoreException coreException) {}
        }
        boolean isDefault = false;
        try {
            isDefault = config.getAttribute("setAsDefault", false);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log((Throwable)ce);
        }
        this.defaultButton.setSelection(isDefault);
    }

    private void updateAllowTerminateFromConfig(ILaunchConfiguration config) {
        boolean allowTerminate = false;
        try {
            allowTerminate = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log((Throwable)ce);
        }
        this.fAllowTerminateButton.setSelection(allowTerminate);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, this.fAllowTerminateButton.getSelection());
        config.setAttribute("setAsDefault", this.defaultButton.getSelection());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, this.getSelectedConnector().getIdentifier());
        this.mapResources(config);
        HashMap<String, String> attrMap = new HashMap<String, String>(2);
        attrMap.put("hostname", this.hostCombo.getText());
        String port = this.getPort();
        if (port != null) {
            attrMap.put("port", port);
        } else {
            attrMap.put("port", "");
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
        if (this.defaultButton.getSelection()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.jboss.tools.common.jdt.debug.launching.JBossRemoteJavaApplication");
            ILaunchConfiguration[] configs = null;
            try {
                configs = manager.getLaunchConfigurations(type);
            }
            catch (CoreException coreException) {
                return;
            }
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                try {
                    boolean isDefault = configuration.getAttribute("setAsDefault", false);
                    if (isDefault && !config.getName().equals(configuration.getName())) {
                        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                        wc.setAttribute("setAsDefault", false);
                        wc.doSave();
                    }
                }
                catch (CoreException e) {
                    RemoteDebugUIActivator.log(e);
                }
                ++n2;
            }
        }
    }

    private String getPort() {
        int portIndex = this.portCombo.getSelectionIndex();
        String port = null;
        if (this.models != null && this.models.length > portIndex && portIndex >= 0) {
            port = this.models[portIndex].getPort();
        }
        return port;
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeHardCodedDefaults(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(javaElement, config);
        }
    }

    private void initializeName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        try {
            IResource resource = javaElement.getUnderlyingResource();
            if (resource != null) {
                name = resource.getName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else {
                name = javaElement.getElementName();
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log((Throwable)jme);
        }
        config.rename(name);
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute("setAsDefault", false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, this.getSelectedConnector().getIdentifier());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(Messages.JavaConnectTab_Project_does_not_exist_14);
            return false;
        }
        if (this.hostCombo.getText().isEmpty()) {
            this.setErrorMessage(Messages.JavaConnectTab_Invalid_Host);
            return false;
        }
        String port = this.getPort();
        if (port == null || port.isEmpty()) {
            this.setErrorMessage(Messages.JavaConnectTab_Invalid_Port);
            return false;
        }
        try {
            new Integer(port);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.JavaConnectTab_Invalid_Port);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.JavaConnectTab_Conn_ect_20;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    public String getId() {
        return "org.jboss.tools.common.jdt.debug.ui.javaConnectTab";
    }

    private IVMConnector getSelectedConnector() {
        if (this.fConnector == null) {
            this.fConnector = RemoteDebugActivator.getDefaultVMConnector();
        }
        return this.fConnector;
    }
}

