/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl.documentation;

import java.text.MessageFormat;
import org.jboss.tools.common.meta.impl.documentation.EntitiesValidator;
import org.jboss.tools.common.meta.impl.documentation.IconsValidator;
import org.jboss.tools.common.meta.impl.documentation.MappingsValidator;
import org.jboss.tools.common.model.XModelObject;

public class MetaValidator {
    private IconsValidator iv = new IconsValidator();
    private EntitiesValidator ev = new EntitiesValidator();

    public void validate(XModelObject metaroot) {
        if (!"MetaRoot".equals(metaroot.getModelEntity().getName())) {
            throw new IllegalArgumentException("Meta validator must be called with MetaRoot.");
        }
        this.iv.validate(metaroot.getChildren("MetaIcons")[0]);
        this.ev.validate(metaroot.getChildren("MetaEntities")[0]);
    }

    public static final void message(String message) {
    }

    public static final String id(XModelObject object) {
        return String.valueOf(object.getAttributeValue("element type")) + " " + object.getModelEntity().getRenderer().getTitle(object);
    }

    public static boolean isBasic(XModelObject object) {
        String e = object.getModelEntity().getName();
        return "MetaEntity".equals(e) || "MetaMapping".equals(e);
    }

    public static String entityId(XModelObject object) {
        while (object != null) {
            if (MetaValidator.isBasic(object)) {
                return MetaValidator.id(object);
            }
            object = object.getParent();
        }
        return "!!!!!!!!!!!!";
    }

    public static final String longid(XModelObject object) {
        return String.valueOf(MetaValidator.id(object)) + (MetaValidator.isBasic(object) ? "" : MessageFormat.format(" of {0}", MetaValidator.entityId(object)));
    }

    public static final void checkClass(XModelObject object, String attribute, boolean mandatory, String mapping) {
        MetaValidator.checkClass(object, attribute, "", mandatory, mapping);
    }

    public static final void checkClass(XModelObject object, String attribute, String prefix, boolean mandatory, String mapping) {
        String pref = MessageFormat.format("Error in attribute ''{0}'' in {1}: ", attribute, MetaValidator.longid(object));
        String classname = object.getAttributeValue(attribute);
        int i = classname.indexOf(37);
        if (classname.length() == 0) {
            if (!mandatory) {
                return;
            }
            MetaValidator.message(String.valueOf(pref) + " class name cannot be empty.");
        } else if (i == 0) {
            if (mapping == null) {
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" alias {0} is not allowed.", classname));
            } else if (classname.charAt(classname.length() - 1) != '%') {
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" incorrect alias {0}", classname));
            } else {
                MappingsValidator.classmappings.add(mapping);
                String alias = classname.substring(1, classname.length() - 1);
                XModelObject v = object.getModel().getByPath("MetaModel/Mappings/" + mapping);
                if (v == null) {
                    MetaValidator.message(MessageFormat.format("Mapping {0} is not found.", mapping));
                }
                if (v.getChildByPath(alias) != null) {
                    return;
                }
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" incorrect alias {0}", classname));
            }
        } else {
            try {
                Class.forName(String.valueOf(prefix) + classname).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" class ''{0}'' not found.", classname));
            }
            catch (InstantiationException instantiationException) {
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" class ''{0}'' not found.", classname));
            }
            catch (IllegalAccessException illegalAccessException) {
                MetaValidator.message(String.valueOf(pref) + MessageFormat.format(" class ''{0}'' not found.", classname));
            }
        }
    }
}

