/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.jboss.tools.common.model.filesystems.FileSystem;
import org.jboss.tools.common.model.filesystems.impl.FileSystemPeer;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;
import org.jboss.tools.common.model.filesystems.impl.LFileObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class FileSystemImpl
extends FolderImpl
implements FileSystem {
    private static final long serialVersionUID = 7212433789685679616L;
    protected FileSystemPeer peer = new FileSystemPeer();
    protected IProject project = null;

    @Override
    public int getFileType() {
        return 3;
    }

    @Override
    protected FileSystemImpl getFileSystem() {
        if (this.getProject() != null) {
            this.getResource();
        }
        return this;
    }

    @Override
    public IProject getProject() {
        if (this.project == null) {
            this.project = EclipseResourceUtil.getProject(this);
        }
        return this.project;
    }

    @Override
    public IContainer getResource() {
        IResource r;
        IPackageFragmentRoot p;
        IJavaProject jp;
        IContainer[] cs;
        File f;
        if (this.getProject() == null || this.resource != null) {
            return this.resource;
        }
        if (!this.project.isOpen() || this.project.getLocation() == null) {
            return this.resource;
        }
        String prloc = this.project.getLocation().toString().replace('\\', '/');
        String thloc = XModelObjectUtil.getExpandedValue(this, "location", null);
        try {
            prloc = new File(prloc).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException iOException) {}
        try {
            f = new File(thloc);
            thloc = f.exists() || thloc.indexOf("/..") >= 0 ? f.getCanonicalPath().replace('\\', '/') : thloc.replace('\\', '/');
        }
        catch (IOException iOException) {
            return null;
        }
        if (thloc.equalsIgnoreCase(prloc)) {
            this.resource = this.project;
            return this.resource;
        }
        if (prloc.toLowerCase().startsWith(thloc.toLowerCase())) {
            this.resource = null;
            return null;
        }
        if (thloc.toLowerCase().startsWith(prloc.toLowerCase())) {
            String relative = thloc.substring(prloc.length());
            IFolder f2 = this.project.getFolder((IPath)new Path(relative));
            if (!f2.exists() && !f2.isSynchronized(1)) {
                try {
                    f2.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            this.resource = f2;
            return this.resource;
        }
        ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().replace('\\', '/');
        f = null;
        URI uri = URIUtil.toURI((String)thloc, (boolean)true);
        IContainer[] iContainerArray = cs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            if (f == null || !c.isLinked()) {
                f = c;
            }
            ++n2;
        }
        if (f != null && !f.exists() && !f.isSynchronized(1)) {
            try {
                f.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (f == null && (jp = EclipseResourceUtil.getJavaProject((IProject)this.getProject())) != null && (p = jp.getPackageFragmentRoot(thloc)) instanceof ExternalPackageFragmentRoot && p.exists() && (r = ((PackageFragmentRoot)p).resource()) instanceof IContainer) {
            f = (IContainer)r;
        }
        this.resource = f;
        if (this.resource == null && (f = this.project.getFolder((IPath)new Path("/" + this.getAttributeValue("name")))).exists()) {
            this.resource = f;
        }
        return this.resource;
    }

    @Override
    protected boolean needUpdateResource() {
        return false;
    }

    public String getAbsoluteLocation() {
        String s = XModelObjectUtil.getExpandedValue(this, "location", null);
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            return new File(s).getCanonicalPath();
        }
        catch (IOException iOException) {
            return s;
        }
    }

    @Override
    public boolean isAttributeEditable(String name) {
        return false;
    }

    @Override
    protected String getAbsolutePath() {
        return this.get("location");
    }

    public FileSystemPeer getPeer() {
        return this.peer;
    }

    @Override
    public String getPathPart() {
        return this.name();
    }

    @Override
    public String getTempLocation() {
        return this.getAbsolutePath();
    }

    public LFileObject getFileObject(String relpath) {
        return new LFileObjectImpl(this.getAbsolutePath(), this.name(), relpath);
    }

    @Override
    public String getMainIconName() {
        String info = this.getAttributeValue("info");
        if (info == null || info.length() == 0) {
            return super.getMainIconName();
        }
        int mr = info.indexOf("Struts-Module=/");
        if (mr >= 0) {
            return "main.struts.moduleroot";
        }
        int wc = info.indexOf("Content-Type=Web");
        if (wc >= 0) {
            return "main.webprj.webroot";
        }
        return super.getMainIconName();
    }

    @Override
    public String getPresentationString() {
        IContainer r = this.getResource();
        String resourceName = r == null ? null : r.getName();
        String natureProperty = this.getModel().getProperties().getProperty("nature");
        if ("org.jboss.tools.jsf.jsfnature".equals(natureProperty)) {
            return resourceName;
        }
        String p = super.getPresentationString();
        if (p == null || p.equals(resourceName)) {
            if (resourceName != null && this.resource.isLinked()) {
                return resourceName.replace('#', '/');
            }
            return resourceName;
        }
        if ("true".equals(this.getModel().getProperties().getProperty("isProjectFragment"))) {
            return resourceName;
        }
        return String.valueOf(p.replace('#', '/')) + " (" + resourceName + ")";
    }
}

